/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshiftserverless.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.redshiftserverless.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateSnapshotRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String namespaceName;
    private Integer retentionPeriod;
    private String snapshotName;
    private List<Tag> tags;

    public void setNamespaceName(String namespaceName) {
        this.namespaceName = namespaceName;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public CreateSnapshotRequest withNamespaceName(String namespaceName) {
        this.setNamespaceName(namespaceName);
        return this;
    }

    public void setRetentionPeriod(Integer retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
    }

    public Integer getRetentionPeriod() {
        return this.retentionPeriod;
    }

    public CreateSnapshotRequest withRetentionPeriod(Integer retentionPeriod) {
        this.setRetentionPeriod(retentionPeriod);
        return this;
    }

    public void setSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public CreateSnapshotRequest withSnapshotName(String snapshotName) {
        this.setSnapshotName(snapshotName);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateSnapshotRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateSnapshotRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNamespaceName() != null) {
            sb.append("NamespaceName: ").append(this.getNamespaceName()).append(",");
        }
        if (this.getRetentionPeriod() != null) {
            sb.append("RetentionPeriod: ").append(this.getRetentionPeriod()).append(",");
        }
        if (this.getSnapshotName() != null) {
            sb.append("SnapshotName: ").append(this.getSnapshotName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnapshotRequest)) {
            return false;
        }
        CreateSnapshotRequest other = (CreateSnapshotRequest)obj;
        if (other.getNamespaceName() == null ^ this.getNamespaceName() == null) {
            return false;
        }
        if (other.getNamespaceName() != null && !other.getNamespaceName().equals(this.getNamespaceName())) {
            return false;
        }
        if (other.getRetentionPeriod() == null ^ this.getRetentionPeriod() == null) {
            return false;
        }
        if (other.getRetentionPeriod() != null && !other.getRetentionPeriod().equals(this.getRetentionPeriod())) {
            return false;
        }
        if (other.getSnapshotName() == null ^ this.getSnapshotName() == null) {
            return false;
        }
        if (other.getSnapshotName() != null && !other.getSnapshotName().equals(this.getSnapshotName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNamespaceName() == null ? 0 : this.getNamespaceName().hashCode());
        hashCode = 31 * hashCode + (this.getRetentionPeriod() == null ? 0 : this.getRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotName() == null ? 0 : this.getSnapshotName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateSnapshotRequest clone() {
        return (CreateSnapshotRequest)super.clone();
    }
}

