/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptographydata.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.paymentcryptographydata.model.MacAlgorithmDukpt;

@SdkInternalApi
public class MacAlgorithmDukptMarshaller {
    private static final MarshallingInfo<String> KEYSERIALNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeySerialNumber").build();
    private static final MarshallingInfo<String> DUKPTKEYVARIANT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DukptKeyVariant").build();
    private static final MarshallingInfo<String> DUKPTDERIVATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DukptDerivationType").build();
    private static final MacAlgorithmDukptMarshaller instance = new MacAlgorithmDukptMarshaller();

    public static MacAlgorithmDukptMarshaller getInstance() {
        return instance;
    }

    public void marshall(MacAlgorithmDukpt macAlgorithmDukpt, ProtocolMarshaller protocolMarshaller) {
        if (macAlgorithmDukpt == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)macAlgorithmDukpt.getKeySerialNumber(), KEYSERIALNUMBER_BINDING);
            protocolMarshaller.marshall((Object)macAlgorithmDukpt.getDukptKeyVariant(), DUKPTKEYVARIANT_BINDING);
            protocolMarshaller.marshall((Object)macAlgorithmDukpt.getDukptDerivationType(), DUKPTDERIVATIONTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

