/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.panorama;

import javax.annotation.Generated;

import com.amazonaws.services.panorama.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSPanorama}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSPanorama implements AWSPanorama {

    protected AbstractAWSPanorama() {
    }

    @Override
    public CreateApplicationInstanceResult createApplicationInstance(CreateApplicationInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateJobForDevicesResult createJobForDevices(CreateJobForDevicesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateNodeFromTemplateJobResult createNodeFromTemplateJob(CreateNodeFromTemplateJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePackageResult createPackage(CreatePackageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePackageImportJobResult createPackageImportJob(CreatePackageImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDeviceResult deleteDevice(DeleteDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePackageResult deletePackage(DeletePackageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeregisterPackageVersionResult deregisterPackageVersion(DeregisterPackageVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeApplicationInstanceResult describeApplicationInstance(DescribeApplicationInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeApplicationInstanceDetailsResult describeApplicationInstanceDetails(DescribeApplicationInstanceDetailsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDeviceResult describeDevice(DescribeDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDeviceJobResult describeDeviceJob(DescribeDeviceJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeNodeResult describeNode(DescribeNodeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeNodeFromTemplateJobResult describeNodeFromTemplateJob(DescribeNodeFromTemplateJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribePackageResult describePackage(DescribePackageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribePackageImportJobResult describePackageImportJob(DescribePackageImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribePackageVersionResult describePackageVersion(DescribePackageVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListApplicationInstanceDependenciesResult listApplicationInstanceDependencies(ListApplicationInstanceDependenciesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListApplicationInstanceNodeInstancesResult listApplicationInstanceNodeInstances(ListApplicationInstanceNodeInstancesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListApplicationInstancesResult listApplicationInstances(ListApplicationInstancesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDevicesResult listDevices(ListDevicesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDevicesJobsResult listDevicesJobs(ListDevicesJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListNodeFromTemplateJobsResult listNodeFromTemplateJobs(ListNodeFromTemplateJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListNodesResult listNodes(ListNodesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPackageImportJobsResult listPackageImportJobs(ListPackageImportJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPackagesResult listPackages(ListPackagesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ProvisionDeviceResult provisionDevice(ProvisionDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RegisterPackageVersionResult registerPackageVersion(RegisterPackageVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RemoveApplicationInstanceResult removeApplicationInstance(RemoveApplicationInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SignalApplicationInstanceNodeInstancesResult signalApplicationInstanceNodeInstances(SignalApplicationInstanceNodeInstancesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDeviceMetadataResult updateDeviceMetadata(UpdateDeviceMetadataRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
