/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.nimblestudio.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateStudioComponent" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateStudioComponentRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify
     * a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to
     * ensure idempotency.
     * </p>
     */
    private String clientToken;
    /**
     * <p>
     * The configuration of the studio component, based on component type.
     * </p>
     */
    private StudioComponentConfiguration configuration;
    /**
     * <p>
     * The description.
     * </p>
     */
    private String description;
    /**
     * <p>
     * The EC2 security groups that control access to the studio component.
     * </p>
     */
    private java.util.List<String> ec2SecurityGroupIds;
    /**
     * <p>
     * Initialization scripts for studio components.
     * </p>
     */
    private java.util.List<StudioComponentInitializationScript> initializationScripts;
    /**
     * <p>
     * The name for the studio component.
     * </p>
     */
    private String name;
    /**
     * <p>
     * An IAM role attached to a Studio Component that gives the studio component access to Amazon Web Services
     * resources at anytime while the instance is running.
     * </p>
     */
    private String runtimeRoleArn;
    /**
     * <p>
     * Parameters for the studio component scripts.
     * </p>
     */
    private java.util.List<ScriptParameterKeyValue> scriptParameters;
    /**
     * <p>
     * An IAM role attached to Studio Component when the system initialization script runs which give the studio
     * component access to Amazon Web Services resources when the system initialization script runs.
     * </p>
     */
    private String secureInitializationRoleArn;
    /**
     * <p>
     * The studio ID.
     * </p>
     */
    private String studioId;
    /**
     * <p>
     * The specific subtype of a studio component.
     * </p>
     */
    private String subtype;
    /**
     * <p>
     * A collection of labels, in the form of key-value pairs, that apply to this resource.
     * </p>
     */
    private java.util.Map<String, String> tags;
    /**
     * <p>
     * The type of the studio component.
     * </p>
     */
    private String type;

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify
     * a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to
     * ensure idempotency.
     * </p>
     * 
     * @param clientToken
     *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t
     *        specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for
     *        the request to ensure idempotency.
     */

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify
     * a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to
     * ensure idempotency.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t
     *         specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it
     *         for the request to ensure idempotency.
     */

    public String getClientToken() {
        return this.clientToken;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify
     * a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the request to
     * ensure idempotency.
     * </p>
     * 
     * @param clientToken
     *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t
     *        specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for
     *        the request to ensure idempotency.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateStudioComponentRequest withClientToken(String clientToken) {
        setClientToken(clientToken);
        return this;
    }

    /**
     * <p>
     * The configuration of the studio component, based on component type.
     * </p>
     * 
     * @param configuration
     *        The configuration of the studio component, based on component type.
     */

    public void setConfiguration(StudioComponentConfiguration configuration) {
        this.configuration = configuration;
    }

    /**
     * <p>
     * The configuration of the studio component, based on component type.
     * </p>
     * 
     * @return The configuration of the studio component, based on component type.
     */

    public StudioComponentConfiguration getConfiguration() {
        return this.configuration;
    }

    /**
     * <p>
     * The configuration of the studio component, based on component type.
     * </p>
     * 
     * @param configuration
     *        The configuration of the studio component, based on component type.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateStudioComponentRequest withConfiguration(StudioComponentConfiguration configuration) {
        setConfiguration(configuration);
        return this;
    }

    /**
     * <p>
     * The description.
     * </p>
     * 
     * @param description
     *        The description.
     */

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * <p>
     * The description.
     * </p>
     * 
     * @return The description.
     */

    public String getDescription() {
        return this.description;
    }

    /**
     * <p>
     * The description.
     * </p>
     * 
     * @param description
     *        The description.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateStudioComponentRequest withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * <p>
     * The EC2 security groups that control access to the studio component.
     * </p>
     * 
     * @return The EC2 security groups that control access to the studio component.
     */

    public java.util.List<String> getEc2SecurityGroupIds() {
        return ec2SecurityGroupIds;
    }

    /**
     * <p>
     * The EC2 security groups that control access to the studio component.
     * </p>
     * 
     * @param ec2SecurityGroupIds
     *        The EC2 security groups that control access to the studio component.
     */

    public void setEc2SecurityGroupIds(java.util.Collection<String> ec2SecurityGroupIds) {
        if (ec2SecurityGroupIds == null) {
            this.ec2SecurityGroupIds = null;
            return;
        }

        this.ec2SecurityGroupIds = new java.util.ArrayList<String>(ec2SecurityGroupIds);
    }

    /**
     * <p>
     * The EC2 security groups that control access to the studio component.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setEc2SecurityGroupIds(java.util.Collection)} or {@link #withEc2SecurityGroupIds(java.util.Collection)}
     * if you want to override the existing values.
     * </p>
     * 
     * @param ec2SecurityGroupIds
     *        The EC2 security groups that control access to the studio component.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateStudioComponentRequest withEc2SecurityGroupIds(String... ec2SecurityGroupIds) {
        if (this.ec2SecurityGroupIds == null) {
            setEc2SecurityGroupIds(new java.util.ArrayList<String>(ec2SecurityGroupIds.length));
        }
        for (String ele : ec2SecurityGroupIds) {
            this.ec2SecurityGroupIds.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The EC2 security groups that control access to the studio component.
     * </p>
     * 
     * @param ec2SecurityGroupIds
     *        The EC2 security groups that control access to the studio component.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateStudioComponentRequest withEc2SecurityGroupIds(java.util.Collection<String> ec2SecurityGroupIds) {
        setEc2SecurityGroupIds(ec2SecurityGroupIds);
        return this;
    }

    /**
     * <p>
     * Initialization scripts for studio components.
     * </p>
     * 
     * @return Initialization scripts for studio components.
     */

    public java.util.List<StudioComponentInitializationScript> getInitializationScripts() {
        return initializationScripts;
    }

    /**
     * <p>
     * Initialization scripts for studio components.
     * </p>
     * 
     * @param initializationScripts
     *        Initialization scripts for studio components.
     */

    public void setInitializationScripts(java.util.Collection<StudioComponentInitializationScript> initializationScripts) {
        if (initializationScripts == null) {
            this.initializationScripts = null;
            return;
        }

        this.initializationScripts = new java.util.ArrayList<StudioComponentInitializationScript>(initializationScripts);
    }

    /**
     * <p>
     * Initialization scripts for studio components.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setInitializationScripts(java.util.Collection)} or
     * {@link #withInitializationScripts(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param initializationScripts
     *        Initialization scripts for studio components.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateStudioComponentRequest withInitializationScripts(StudioComponentInitializationScript... initializationScripts) {
        if (this.initializationScripts == null) {
            setInitializationScripts(new java.util.ArrayList<StudioComponentInitializationScript>(initializationScripts.length));
        }
        for (StudioComponentInitializationScript ele : initializationScripts) {
            this.initializationScripts.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Initialization scripts for studio components.
     * </p>
     * 
     * @param initializationScripts
     *        Initialization scripts for studio components.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateStudioComponentRequest withInitializationScripts(java.util.Collection<StudioComponentInitializationScript> initializationScripts) {
        setInitializationScripts(initializationScripts);
        return this;
    }

    /**
     * <p>
     * The name for the studio component.
     * </p>
     * 
     * @param name
     *        The name for the studio component.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The name for the studio component.
     * </p>
     * 
     * @return The name for the studio component.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The name for the studio component.
     * </p>
     * 
     * @param name
     *        The name for the studio component.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateStudioComponentRequest withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * An IAM role attached to a Studio Component that gives the studio component access to Amazon Web Services
     * resources at anytime while the instance is running.
     * </p>
     * 
     * @param runtimeRoleArn
     *        An IAM role attached to a Studio Component that gives the studio component access to Amazon Web Services
     *        resources at anytime while the instance is running.
     */

    public void setRuntimeRoleArn(String runtimeRoleArn) {
        this.runtimeRoleArn = runtimeRoleArn;
    }

    /**
     * <p>
     * An IAM role attached to a Studio Component that gives the studio component access to Amazon Web Services
     * resources at anytime while the instance is running.
     * </p>
     * 
     * @return An IAM role attached to a Studio Component that gives the studio component access to Amazon Web Services
     *         resources at anytime while the instance is running.
     */

    public String getRuntimeRoleArn() {
        return this.runtimeRoleArn;
    }

    /**
     * <p>
     * An IAM role attached to a Studio Component that gives the studio component access to Amazon Web Services
     * resources at anytime while the instance is running.
     * </p>
     * 
     * @param runtimeRoleArn
     *        An IAM role attached to a Studio Component that gives the studio component access to Amazon Web Services
     *        resources at anytime while the instance is running.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateStudioComponentRequest withRuntimeRoleArn(String runtimeRoleArn) {
        setRuntimeRoleArn(runtimeRoleArn);
        return this;
    }

    /**
     * <p>
     * Parameters for the studio component scripts.
     * </p>
     * 
     * @return Parameters for the studio component scripts.
     */

    public java.util.List<ScriptParameterKeyValue> getScriptParameters() {
        return scriptParameters;
    }

    /**
     * <p>
     * Parameters for the studio component scripts.
     * </p>
     * 
     * @param scriptParameters
     *        Parameters for the studio component scripts.
     */

    public void setScriptParameters(java.util.Collection<ScriptParameterKeyValue> scriptParameters) {
        if (scriptParameters == null) {
            this.scriptParameters = null;
            return;
        }

        this.scriptParameters = new java.util.ArrayList<ScriptParameterKeyValue>(scriptParameters);
    }

    /**
     * <p>
     * Parameters for the studio component scripts.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setScriptParameters(java.util.Collection)} or {@link #withScriptParameters(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param scriptParameters
     *        Parameters for the studio component scripts.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateStudioComponentRequest withScriptParameters(ScriptParameterKeyValue... scriptParameters) {
        if (this.scriptParameters == null) {
            setScriptParameters(new java.util.ArrayList<ScriptParameterKeyValue>(scriptParameters.length));
        }
        for (ScriptParameterKeyValue ele : scriptParameters) {
            this.scriptParameters.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Parameters for the studio component scripts.
     * </p>
     * 
     * @param scriptParameters
     *        Parameters for the studio component scripts.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateStudioComponentRequest withScriptParameters(java.util.Collection<ScriptParameterKeyValue> scriptParameters) {
        setScriptParameters(scriptParameters);
        return this;
    }

    /**
     * <p>
     * An IAM role attached to Studio Component when the system initialization script runs which give the studio
     * component access to Amazon Web Services resources when the system initialization script runs.
     * </p>
     * 
     * @param secureInitializationRoleArn
     *        An IAM role attached to Studio Component when the system initialization script runs which give the studio
     *        component access to Amazon Web Services resources when the system initialization script runs.
     */

    public void setSecureInitializationRoleArn(String secureInitializationRoleArn) {
        this.secureInitializationRoleArn = secureInitializationRoleArn;
    }

    /**
     * <p>
     * An IAM role attached to Studio Component when the system initialization script runs which give the studio
     * component access to Amazon Web Services resources when the system initialization script runs.
     * </p>
     * 
     * @return An IAM role attached to Studio Component when the system initialization script runs which give the studio
     *         component access to Amazon Web Services resources when the system initialization script runs.
     */

    public String getSecureInitializationRoleArn() {
        return this.secureInitializationRoleArn;
    }

    /**
     * <p>
     * An IAM role attached to Studio Component when the system initialization script runs which give the studio
     * component access to Amazon Web Services resources when the system initialization script runs.
     * </p>
     * 
     * @param secureInitializationRoleArn
     *        An IAM role attached to Studio Component when the system initialization script runs which give the studio
     *        component access to Amazon Web Services resources when the system initialization script runs.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateStudioComponentRequest withSecureInitializationRoleArn(String secureInitializationRoleArn) {
        setSecureInitializationRoleArn(secureInitializationRoleArn);
        return this;
    }

    /**
     * <p>
     * The studio ID.
     * </p>
     * 
     * @param studioId
     *        The studio ID.
     */

    public void setStudioId(String studioId) {
        this.studioId = studioId;
    }

    /**
     * <p>
     * The studio ID.
     * </p>
     * 
     * @return The studio ID.
     */

    public String getStudioId() {
        return this.studioId;
    }

    /**
     * <p>
     * The studio ID.
     * </p>
     * 
     * @param studioId
     *        The studio ID.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateStudioComponentRequest withStudioId(String studioId) {
        setStudioId(studioId);
        return this;
    }

    /**
     * <p>
     * The specific subtype of a studio component.
     * </p>
     * 
     * @param subtype
     *        The specific subtype of a studio component.
     * @see StudioComponentSubtype
     */

    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    /**
     * <p>
     * The specific subtype of a studio component.
     * </p>
     * 
     * @return The specific subtype of a studio component.
     * @see StudioComponentSubtype
     */

    public String getSubtype() {
        return this.subtype;
    }

    /**
     * <p>
     * The specific subtype of a studio component.
     * </p>
     * 
     * @param subtype
     *        The specific subtype of a studio component.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see StudioComponentSubtype
     */

    public CreateStudioComponentRequest withSubtype(String subtype) {
        setSubtype(subtype);
        return this;
    }

    /**
     * <p>
     * The specific subtype of a studio component.
     * </p>
     * 
     * @param subtype
     *        The specific subtype of a studio component.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see StudioComponentSubtype
     */

    public CreateStudioComponentRequest withSubtype(StudioComponentSubtype subtype) {
        this.subtype = subtype.toString();
        return this;
    }

    /**
     * <p>
     * A collection of labels, in the form of key-value pairs, that apply to this resource.
     * </p>
     * 
     * @return A collection of labels, in the form of key-value pairs, that apply to this resource.
     */

    public java.util.Map<String, String> getTags() {
        return tags;
    }

    /**
     * <p>
     * A collection of labels, in the form of key-value pairs, that apply to this resource.
     * </p>
     * 
     * @param tags
     *        A collection of labels, in the form of key-value pairs, that apply to this resource.
     */

    public void setTags(java.util.Map<String, String> tags) {
        this.tags = tags;
    }

    /**
     * <p>
     * A collection of labels, in the form of key-value pairs, that apply to this resource.
     * </p>
     * 
     * @param tags
     *        A collection of labels, in the form of key-value pairs, that apply to this resource.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateStudioComponentRequest withTags(java.util.Map<String, String> tags) {
        setTags(tags);
        return this;
    }

    /**
     * Add a single Tags entry
     *
     * @see CreateStudioComponentRequest#withTags
     * @returns a reference to this object so that method calls can be chained together.
     */

    public CreateStudioComponentRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new java.util.HashMap<String, String>();
        }
        if (this.tags.containsKey(key))
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        this.tags.put(key, value);
        return this;
    }

    /**
     * Removes all the entries added into Tags.
     *
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateStudioComponentRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    /**
     * <p>
     * The type of the studio component.
     * </p>
     * 
     * @param type
     *        The type of the studio component.
     * @see StudioComponentType
     */

    public void setType(String type) {
        this.type = type;
    }

    /**
     * <p>
     * The type of the studio component.
     * </p>
     * 
     * @return The type of the studio component.
     * @see StudioComponentType
     */

    public String getType() {
        return this.type;
    }

    /**
     * <p>
     * The type of the studio component.
     * </p>
     * 
     * @param type
     *        The type of the studio component.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see StudioComponentType
     */

    public CreateStudioComponentRequest withType(String type) {
        setType(type);
        return this;
    }

    /**
     * <p>
     * The type of the studio component.
     * </p>
     * 
     * @param type
     *        The type of the studio component.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see StudioComponentType
     */

    public CreateStudioComponentRequest withType(StudioComponentType type) {
        this.type = type.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getClientToken() != null)
            sb.append("ClientToken: ").append(getClientToken()).append(",");
        if (getConfiguration() != null)
            sb.append("Configuration: ").append(getConfiguration()).append(",");
        if (getDescription() != null)
            sb.append("Description: ").append("***Sensitive Data Redacted***").append(",");
        if (getEc2SecurityGroupIds() != null)
            sb.append("Ec2SecurityGroupIds: ").append(getEc2SecurityGroupIds()).append(",");
        if (getInitializationScripts() != null)
            sb.append("InitializationScripts: ").append(getInitializationScripts()).append(",");
        if (getName() != null)
            sb.append("Name: ").append("***Sensitive Data Redacted***").append(",");
        if (getRuntimeRoleArn() != null)
            sb.append("RuntimeRoleArn: ").append(getRuntimeRoleArn()).append(",");
        if (getScriptParameters() != null)
            sb.append("ScriptParameters: ").append("***Sensitive Data Redacted***").append(",");
        if (getSecureInitializationRoleArn() != null)
            sb.append("SecureInitializationRoleArn: ").append(getSecureInitializationRoleArn()).append(",");
        if (getStudioId() != null)
            sb.append("StudioId: ").append(getStudioId()).append(",");
        if (getSubtype() != null)
            sb.append("Subtype: ").append(getSubtype()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags()).append(",");
        if (getType() != null)
            sb.append("Type: ").append(getType());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateStudioComponentRequest == false)
            return false;
        CreateStudioComponentRequest other = (CreateStudioComponentRequest) obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null)
            return false;
        if (other.getClientToken() != null && other.getClientToken().equals(this.getClientToken()) == false)
            return false;
        if (other.getConfiguration() == null ^ this.getConfiguration() == null)
            return false;
        if (other.getConfiguration() != null && other.getConfiguration().equals(this.getConfiguration()) == false)
            return false;
        if (other.getDescription() == null ^ this.getDescription() == null)
            return false;
        if (other.getDescription() != null && other.getDescription().equals(this.getDescription()) == false)
            return false;
        if (other.getEc2SecurityGroupIds() == null ^ this.getEc2SecurityGroupIds() == null)
            return false;
        if (other.getEc2SecurityGroupIds() != null && other.getEc2SecurityGroupIds().equals(this.getEc2SecurityGroupIds()) == false)
            return false;
        if (other.getInitializationScripts() == null ^ this.getInitializationScripts() == null)
            return false;
        if (other.getInitializationScripts() != null && other.getInitializationScripts().equals(this.getInitializationScripts()) == false)
            return false;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getRuntimeRoleArn() == null ^ this.getRuntimeRoleArn() == null)
            return false;
        if (other.getRuntimeRoleArn() != null && other.getRuntimeRoleArn().equals(this.getRuntimeRoleArn()) == false)
            return false;
        if (other.getScriptParameters() == null ^ this.getScriptParameters() == null)
            return false;
        if (other.getScriptParameters() != null && other.getScriptParameters().equals(this.getScriptParameters()) == false)
            return false;
        if (other.getSecureInitializationRoleArn() == null ^ this.getSecureInitializationRoleArn() == null)
            return false;
        if (other.getSecureInitializationRoleArn() != null && other.getSecureInitializationRoleArn().equals(this.getSecureInitializationRoleArn()) == false)
            return false;
        if (other.getStudioId() == null ^ this.getStudioId() == null)
            return false;
        if (other.getStudioId() != null && other.getStudioId().equals(this.getStudioId()) == false)
            return false;
        if (other.getSubtype() == null ^ this.getSubtype() == null)
            return false;
        if (other.getSubtype() != null && other.getSubtype().equals(this.getSubtype()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        if (other.getType() == null ^ this.getType() == null)
            return false;
        if (other.getType() != null && other.getType().equals(this.getType()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getClientToken() == null) ? 0 : getClientToken().hashCode());
        hashCode = prime * hashCode + ((getConfiguration() == null) ? 0 : getConfiguration().hashCode());
        hashCode = prime * hashCode + ((getDescription() == null) ? 0 : getDescription().hashCode());
        hashCode = prime * hashCode + ((getEc2SecurityGroupIds() == null) ? 0 : getEc2SecurityGroupIds().hashCode());
        hashCode = prime * hashCode + ((getInitializationScripts() == null) ? 0 : getInitializationScripts().hashCode());
        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getRuntimeRoleArn() == null) ? 0 : getRuntimeRoleArn().hashCode());
        hashCode = prime * hashCode + ((getScriptParameters() == null) ? 0 : getScriptParameters().hashCode());
        hashCode = prime * hashCode + ((getSecureInitializationRoleArn() == null) ? 0 : getSecureInitializationRoleArn().hashCode());
        hashCode = prime * hashCode + ((getStudioId() == null) ? 0 : getStudioId().hashCode());
        hashCode = prime * hashCode + ((getSubtype() == null) ? 0 : getSubtype().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        hashCode = prime * hashCode + ((getType() == null) ? 0 : getType().hashCode());
        return hashCode;
    }

    @Override
    public CreateStudioComponentRequest clone() {
        return (CreateStudioComponentRequest) super.clone();
    }

}
