/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkmanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.networkmanager.model.Tag;
import com.amazonaws.services.networkmanager.model.transform.ProposedSegmentChangeMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ProposedSegmentChange
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Tag> tags;
    private Integer attachmentPolicyRuleNumber;
    private String segmentName;

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public ProposedSegmentChange withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public ProposedSegmentChange withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setAttachmentPolicyRuleNumber(Integer attachmentPolicyRuleNumber) {
        this.attachmentPolicyRuleNumber = attachmentPolicyRuleNumber;
    }

    public Integer getAttachmentPolicyRuleNumber() {
        return this.attachmentPolicyRuleNumber;
    }

    public ProposedSegmentChange withAttachmentPolicyRuleNumber(Integer attachmentPolicyRuleNumber) {
        this.setAttachmentPolicyRuleNumber(attachmentPolicyRuleNumber);
        return this;
    }

    public void setSegmentName(String segmentName) {
        this.segmentName = segmentName;
    }

    public String getSegmentName() {
        return this.segmentName;
    }

    public ProposedSegmentChange withSegmentName(String segmentName) {
        this.setSegmentName(segmentName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getAttachmentPolicyRuleNumber() != null) {
            sb.append("AttachmentPolicyRuleNumber: ").append(this.getAttachmentPolicyRuleNumber()).append(",");
        }
        if (this.getSegmentName() != null) {
            sb.append("SegmentName: ").append(this.getSegmentName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProposedSegmentChange)) {
            return false;
        }
        ProposedSegmentChange other = (ProposedSegmentChange)obj;
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getAttachmentPolicyRuleNumber() == null ^ this.getAttachmentPolicyRuleNumber() == null) {
            return false;
        }
        if (other.getAttachmentPolicyRuleNumber() != null && !other.getAttachmentPolicyRuleNumber().equals(this.getAttachmentPolicyRuleNumber())) {
            return false;
        }
        if (other.getSegmentName() == null ^ this.getSegmentName() == null) {
            return false;
        }
        return other.getSegmentName() == null || other.getSegmentName().equals(this.getSegmentName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getAttachmentPolicyRuleNumber() == null ? 0 : this.getAttachmentPolicyRuleNumber().hashCode());
        hashCode = 31 * hashCode + (this.getSegmentName() == null ? 0 : this.getSegmentName().hashCode());
        return hashCode;
    }

    public ProposedSegmentChange clone() {
        try {
            return (ProposedSegmentChange)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProposedSegmentChangeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

