/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkmanager.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.networkmanager.model.Bandwidth;

@SdkInternalApi
public class BandwidthMarshaller {
    private static final MarshallingInfo<Integer> UPLOADSPEED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UploadSpeed").build();
    private static final MarshallingInfo<Integer> DOWNLOADSPEED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DownloadSpeed").build();
    private static final BandwidthMarshaller instance = new BandwidthMarshaller();

    public static BandwidthMarshaller getInstance() {
        return instance;
    }

    public void marshall(Bandwidth bandwidth, ProtocolMarshaller protocolMarshaller) {
        if (bandwidth == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)bandwidth.getUploadSpeed(), UPLOADSPEED_BINDING);
            protocolMarshaller.marshall((Object)bandwidth.getDownloadSpeed(), DOWNLOADSPEED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

