/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexmodelbuilding.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lexmodelbuilding.model.MigrationAlertType;
import com.amazonaws.services.lexmodelbuilding.model.transform.MigrationAlertMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MigrationAlert
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private String message;
    private List<String> details;
    private List<String> referenceURLs;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public MigrationAlert withType(String type) {
        this.setType(type);
        return this;
    }

    public MigrationAlert withType(MigrationAlertType type) {
        this.type = type.toString();
        return this;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public MigrationAlert withMessage(String message) {
        this.setMessage(message);
        return this;
    }

    public List<String> getDetails() {
        return this.details;
    }

    public void setDetails(Collection<String> details) {
        if (details == null) {
            this.details = null;
            return;
        }
        this.details = new ArrayList<String>(details);
    }

    public MigrationAlert withDetails(String ... details) {
        if (this.details == null) {
            this.setDetails(new ArrayList<String>(details.length));
        }
        for (String ele : details) {
            this.details.add(ele);
        }
        return this;
    }

    public MigrationAlert withDetails(Collection<String> details) {
        this.setDetails(details);
        return this;
    }

    public List<String> getReferenceURLs() {
        return this.referenceURLs;
    }

    public void setReferenceURLs(Collection<String> referenceURLs) {
        if (referenceURLs == null) {
            this.referenceURLs = null;
            return;
        }
        this.referenceURLs = new ArrayList<String>(referenceURLs);
    }

    public MigrationAlert withReferenceURLs(String ... referenceURLs) {
        if (this.referenceURLs == null) {
            this.setReferenceURLs(new ArrayList<String>(referenceURLs.length));
        }
        for (String ele : referenceURLs) {
            this.referenceURLs.add(ele);
        }
        return this;
    }

    public MigrationAlert withReferenceURLs(Collection<String> referenceURLs) {
        this.setReferenceURLs(referenceURLs);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getMessage() != null) {
            sb.append("Message: ").append(this.getMessage()).append(",");
        }
        if (this.getDetails() != null) {
            sb.append("Details: ").append(this.getDetails()).append(",");
        }
        if (this.getReferenceURLs() != null) {
            sb.append("ReferenceURLs: ").append(this.getReferenceURLs());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MigrationAlert)) {
            return false;
        }
        MigrationAlert other = (MigrationAlert)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getMessage() == null ^ this.getMessage() == null) {
            return false;
        }
        if (other.getMessage() != null && !other.getMessage().equals(this.getMessage())) {
            return false;
        }
        if (other.getDetails() == null ^ this.getDetails() == null) {
            return false;
        }
        if (other.getDetails() != null && !other.getDetails().equals(this.getDetails())) {
            return false;
        }
        if (other.getReferenceURLs() == null ^ this.getReferenceURLs() == null) {
            return false;
        }
        return other.getReferenceURLs() == null || other.getReferenceURLs().equals(this.getReferenceURLs());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        hashCode = 31 * hashCode + (this.getDetails() == null ? 0 : this.getDetails().hashCode());
        hashCode = 31 * hashCode + (this.getReferenceURLs() == null ? 0 : this.getReferenceURLs().hashCode());
        return hashCode;
    }

    public MigrationAlert clone() {
        try {
            return (MigrationAlert)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MigrationAlertMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

