/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.frauddetector.model.transform.EvaluatedExternalModelMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class EvaluatedExternalModel
implements Serializable,
Cloneable,
StructuredPojo {
    private String modelEndpoint;
    private Boolean useEventVariables;
    private Map<String, String> inputVariables;
    private Map<String, String> outputVariables;

    public void setModelEndpoint(String modelEndpoint) {
        this.modelEndpoint = modelEndpoint;
    }

    public String getModelEndpoint() {
        return this.modelEndpoint;
    }

    public EvaluatedExternalModel withModelEndpoint(String modelEndpoint) {
        this.setModelEndpoint(modelEndpoint);
        return this;
    }

    public void setUseEventVariables(Boolean useEventVariables) {
        this.useEventVariables = useEventVariables;
    }

    public Boolean getUseEventVariables() {
        return this.useEventVariables;
    }

    public EvaluatedExternalModel withUseEventVariables(Boolean useEventVariables) {
        this.setUseEventVariables(useEventVariables);
        return this;
    }

    public Boolean isUseEventVariables() {
        return this.useEventVariables;
    }

    public Map<String, String> getInputVariables() {
        return this.inputVariables;
    }

    public void setInputVariables(Map<String, String> inputVariables) {
        this.inputVariables = inputVariables;
    }

    public EvaluatedExternalModel withInputVariables(Map<String, String> inputVariables) {
        this.setInputVariables(inputVariables);
        return this;
    }

    public EvaluatedExternalModel addInputVariablesEntry(String key, String value) {
        if (null == this.inputVariables) {
            this.inputVariables = new HashMap<String, String>();
        }
        if (this.inputVariables.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.inputVariables.put(key, value);
        return this;
    }

    public EvaluatedExternalModel clearInputVariablesEntries() {
        this.inputVariables = null;
        return this;
    }

    public Map<String, String> getOutputVariables() {
        return this.outputVariables;
    }

    public void setOutputVariables(Map<String, String> outputVariables) {
        this.outputVariables = outputVariables;
    }

    public EvaluatedExternalModel withOutputVariables(Map<String, String> outputVariables) {
        this.setOutputVariables(outputVariables);
        return this;
    }

    public EvaluatedExternalModel addOutputVariablesEntry(String key, String value) {
        if (null == this.outputVariables) {
            this.outputVariables = new HashMap<String, String>();
        }
        if (this.outputVariables.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.outputVariables.put(key, value);
        return this;
    }

    public EvaluatedExternalModel clearOutputVariablesEntries() {
        this.outputVariables = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getModelEndpoint() != null) {
            sb.append("ModelEndpoint: ").append(this.getModelEndpoint()).append(",");
        }
        if (this.getUseEventVariables() != null) {
            sb.append("UseEventVariables: ").append(this.getUseEventVariables()).append(",");
        }
        if (this.getInputVariables() != null) {
            sb.append("InputVariables: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getOutputVariables() != null) {
            sb.append("OutputVariables: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluatedExternalModel)) {
            return false;
        }
        EvaluatedExternalModel other = (EvaluatedExternalModel)obj;
        if (other.getModelEndpoint() == null ^ this.getModelEndpoint() == null) {
            return false;
        }
        if (other.getModelEndpoint() != null && !other.getModelEndpoint().equals(this.getModelEndpoint())) {
            return false;
        }
        if (other.getUseEventVariables() == null ^ this.getUseEventVariables() == null) {
            return false;
        }
        if (other.getUseEventVariables() != null && !other.getUseEventVariables().equals(this.getUseEventVariables())) {
            return false;
        }
        if (other.getInputVariables() == null ^ this.getInputVariables() == null) {
            return false;
        }
        if (other.getInputVariables() != null && !other.getInputVariables().equals(this.getInputVariables())) {
            return false;
        }
        if (other.getOutputVariables() == null ^ this.getOutputVariables() == null) {
            return false;
        }
        return other.getOutputVariables() == null || other.getOutputVariables().equals(this.getOutputVariables());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getModelEndpoint() == null ? 0 : this.getModelEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getUseEventVariables() == null ? 0 : this.getUseEventVariables().hashCode());
        hashCode = 31 * hashCode + (this.getInputVariables() == null ? 0 : this.getInputVariables().hashCode());
        hashCode = 31 * hashCode + (this.getOutputVariables() == null ? 0 : this.getOutputVariables().hashCode());
        return hashCode;
    }

    public EvaluatedExternalModel clone() {
        try {
            return (EvaluatedExternalModel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EvaluatedExternalModelMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

