/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.entityresolution;

import javax.annotation.Generated;

import com.amazonaws.services.entityresolution.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSEntityResolution}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSEntityResolution implements AWSEntityResolution {

    protected AbstractAWSEntityResolution() {
    }

    @Override
    public AddPolicyStatementResult addPolicyStatement(AddPolicyStatementRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchDeleteUniqueIdResult batchDeleteUniqueId(BatchDeleteUniqueIdRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateIdMappingWorkflowResult createIdMappingWorkflow(CreateIdMappingWorkflowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateIdNamespaceResult createIdNamespace(CreateIdNamespaceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateMatchingWorkflowResult createMatchingWorkflow(CreateMatchingWorkflowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSchemaMappingResult createSchemaMapping(CreateSchemaMappingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteIdMappingWorkflowResult deleteIdMappingWorkflow(DeleteIdMappingWorkflowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteIdNamespaceResult deleteIdNamespace(DeleteIdNamespaceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMatchingWorkflowResult deleteMatchingWorkflow(DeleteMatchingWorkflowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePolicyStatementResult deletePolicyStatement(DeletePolicyStatementRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSchemaMappingResult deleteSchemaMapping(DeleteSchemaMappingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetIdMappingJobResult getIdMappingJob(GetIdMappingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetIdMappingWorkflowResult getIdMappingWorkflow(GetIdMappingWorkflowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetIdNamespaceResult getIdNamespace(GetIdNamespaceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMatchIdResult getMatchId(GetMatchIdRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMatchingJobResult getMatchingJob(GetMatchingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMatchingWorkflowResult getMatchingWorkflow(GetMatchingWorkflowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPolicyResult getPolicy(GetPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSchemaMappingResult getSchemaMapping(GetSchemaMappingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListIdMappingJobsResult listIdMappingJobs(ListIdMappingJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListIdMappingWorkflowsResult listIdMappingWorkflows(ListIdMappingWorkflowsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListIdNamespacesResult listIdNamespaces(ListIdNamespacesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMatchingJobsResult listMatchingJobs(ListMatchingJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMatchingWorkflowsResult listMatchingWorkflows(ListMatchingWorkflowsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListProviderServicesResult listProviderServices(ListProviderServicesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSchemaMappingsResult listSchemaMappings(ListSchemaMappingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutPolicyResult putPolicy(PutPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartIdMappingJobResult startIdMappingJob(StartIdMappingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartMatchingJobResult startMatchingJob(StartMatchingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateIdMappingWorkflowResult updateIdMappingWorkflow(UpdateIdMappingWorkflowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateIdNamespaceResult updateIdNamespace(UpdateIdNamespaceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateMatchingWorkflowResult updateMatchingWorkflow(UpdateMatchingWorkflowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSchemaMappingResult updateSchemaMapping(UpdateSchemaMappingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
