/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest;
import com.amazonaws.services.elasticloadbalancing.model.PolicyAttribute;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CreateLoadBalancerPolicyRequestMarshaller
implements Marshaller<Request<CreateLoadBalancerPolicyRequest>, CreateLoadBalancerPolicyRequest> {
    public Request<CreateLoadBalancerPolicyRequest> marshall(CreateLoadBalancerPolicyRequest createLoadBalancerPolicyRequest) {
        if (createLoadBalancerPolicyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createLoadBalancerPolicyRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "CreateLoadBalancerPolicy");
        request.addParameter("Version", "2012-06-01");
        if (createLoadBalancerPolicyRequest.getLoadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringUtils.fromString((String)createLoadBalancerPolicyRequest.getLoadBalancerName()));
        }
        if (createLoadBalancerPolicyRequest.getPolicyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString((String)createLoadBalancerPolicyRequest.getPolicyName()));
        }
        if (createLoadBalancerPolicyRequest.getPolicyTypeName() != null) {
            request.addParameter("PolicyTypeName", StringUtils.fromString((String)createLoadBalancerPolicyRequest.getPolicyTypeName()));
        }
        List<PolicyAttribute> policyAttributesList = createLoadBalancerPolicyRequest.getPolicyAttributes();
        int policyAttributesListIndex = 1;
        for (PolicyAttribute policyAttributesListValue : policyAttributesList) {
            PolicyAttribute policyAttributeMember = policyAttributesListValue;
            if (policyAttributeMember != null) {
                if (policyAttributeMember.getAttributeName() != null) {
                    request.addParameter("PolicyAttributes.member." + policyAttributesListIndex + ".AttributeName", StringUtils.fromString((String)policyAttributeMember.getAttributeName()));
                }
                if (policyAttributeMember.getAttributeValue() != null) {
                    request.addParameter("PolicyAttributes.member." + policyAttributesListIndex + ".AttributeValue", StringUtils.fromString((String)policyAttributeMember.getAttributeValue()));
                }
            }
            ++policyAttributesListIndex;
        }
        return request;
    }
}

