/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.controltower.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.controltower.model.BaselineSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListBaselinesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<BaselineSummary> baselines;
    private String nextToken;

    public List<BaselineSummary> getBaselines() {
        return this.baselines;
    }

    public void setBaselines(Collection<BaselineSummary> baselines) {
        if (baselines == null) {
            this.baselines = null;
            return;
        }
        this.baselines = new ArrayList<BaselineSummary>(baselines);
    }

    public ListBaselinesResult withBaselines(BaselineSummary ... baselines) {
        if (this.baselines == null) {
            this.setBaselines(new ArrayList<BaselineSummary>(baselines.length));
        }
        for (BaselineSummary ele : baselines) {
            this.baselines.add(ele);
        }
        return this;
    }

    public ListBaselinesResult withBaselines(Collection<BaselineSummary> baselines) {
        this.setBaselines(baselines);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListBaselinesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBaselines() != null) {
            sb.append("Baselines: ").append(this.getBaselines()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBaselinesResult)) {
            return false;
        }
        ListBaselinesResult other = (ListBaselinesResult)obj;
        if (other.getBaselines() == null ^ this.getBaselines() == null) {
            return false;
        }
        if (other.getBaselines() != null && !other.getBaselines().equals(this.getBaselines())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBaselines() == null ? 0 : this.getBaselines().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListBaselinesResult clone() {
        try {
            return (ListBaselinesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

