/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevidently.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cloudwatchevidently.model.Project;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class ProjectMarshaller {
    private static final MarshallingInfo<Long> ACTIVEEXPERIMENTCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("activeExperimentCount").build();
    private static final MarshallingInfo<Long> ACTIVELAUNCHCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("activeLaunchCount").build();
    private static final MarshallingInfo<StructuredPojo> APPCONFIGRESOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("appConfigResource").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<Date> CREATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> DATADELIVERY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dataDelivery").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<Long> EXPERIMENTCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("experimentCount").build();
    private static final MarshallingInfo<Long> FEATURECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("featureCount").build();
    private static final MarshallingInfo<Date> LASTUPDATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Long> LAUNCHCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("launchCount").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final ProjectMarshaller instance = new ProjectMarshaller();

    public static ProjectMarshaller getInstance() {
        return instance;
    }

    public void marshall(Project project, ProtocolMarshaller protocolMarshaller) {
        if (project == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)project.getActiveExperimentCount(), ACTIVEEXPERIMENTCOUNT_BINDING);
            protocolMarshaller.marshall((Object)project.getActiveLaunchCount(), ACTIVELAUNCHCOUNT_BINDING);
            protocolMarshaller.marshall((Object)project.getAppConfigResource(), APPCONFIGRESOURCE_BINDING);
            protocolMarshaller.marshall((Object)project.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)project.getCreatedTime(), CREATEDTIME_BINDING);
            protocolMarshaller.marshall((Object)project.getDataDelivery(), DATADELIVERY_BINDING);
            protocolMarshaller.marshall((Object)project.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)project.getExperimentCount(), EXPERIMENTCOUNT_BINDING);
            protocolMarshaller.marshall((Object)project.getFeatureCount(), FEATURECOUNT_BINDING);
            protocolMarshaller.marshall((Object)project.getLastUpdatedTime(), LASTUPDATEDTIME_BINDING);
            protocolMarshaller.marshall((Object)project.getLaunchCount(), LAUNCHCOUNT_BINDING);
            protocolMarshaller.marshall((Object)project.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)project.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(project.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

