/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.billingconductor.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.billingconductor.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * BillingGroupCostReportResultElementMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class BillingGroupCostReportResultElementMarshaller {

    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Arn").build();
    private static final MarshallingInfo<String> AWSCOST_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("AWSCost").build();
    private static final MarshallingInfo<String> PROFORMACOST_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProformaCost").build();
    private static final MarshallingInfo<String> MARGIN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Margin").build();
    private static final MarshallingInfo<String> MARGINPERCENTAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MarginPercentage").build();
    private static final MarshallingInfo<String> CURRENCY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Currency").build();
    private static final MarshallingInfo<List> ATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Attributes").build();

    private static final BillingGroupCostReportResultElementMarshaller instance = new BillingGroupCostReportResultElementMarshaller();

    public static BillingGroupCostReportResultElementMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(BillingGroupCostReportResultElement billingGroupCostReportResultElement, ProtocolMarshaller protocolMarshaller) {

        if (billingGroupCostReportResultElement == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(billingGroupCostReportResultElement.getArn(), ARN_BINDING);
            protocolMarshaller.marshall(billingGroupCostReportResultElement.getAWSCost(), AWSCOST_BINDING);
            protocolMarshaller.marshall(billingGroupCostReportResultElement.getProformaCost(), PROFORMACOST_BINDING);
            protocolMarshaller.marshall(billingGroupCostReportResultElement.getMargin(), MARGIN_BINDING);
            protocolMarshaller.marshall(billingGroupCostReportResultElement.getMarginPercentage(), MARGINPERCENTAGE_BINDING);
            protocolMarshaller.marshall(billingGroupCostReportResultElement.getCurrency(), CURRENCY_BINDING);
            protocolMarshaller.marshall(billingGroupCostReportResultElement.getAttributes(), ATTRIBUTES_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
