/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrock.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrock.model.CloudWatchConfig;

@SdkInternalApi
public class CloudWatchConfigMarshaller {
    private static final MarshallingInfo<String> LOGGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logGroupName").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").build();
    private static final MarshallingInfo<StructuredPojo> LARGEDATADELIVERYS3CONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("largeDataDeliveryS3Config").build();
    private static final CloudWatchConfigMarshaller instance = new CloudWatchConfigMarshaller();

    public static CloudWatchConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(CloudWatchConfig cloudWatchConfig, ProtocolMarshaller protocolMarshaller) {
        if (cloudWatchConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cloudWatchConfig.getLogGroupName(), LOGGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchConfig.getRoleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchConfig.getLargeDataDeliveryS3Config(), LARGEDATADELIVERYS3CONFIG_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

