/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging;

import com.amazon.sqs.javamessaging.SQSConnection;
import com.amazon.sqs.javamessaging.SQSMessageConsumerPrefetch;
import com.amazon.sqs.javamessaging.SQSQueueDestination;
import com.amazon.sqs.javamessaging.SQSSession;
import com.amazon.sqs.javamessaging.SQSSessionCallbackScheduler;
import com.amazon.sqs.javamessaging.acknowledge.Acknowledger;
import com.amazon.sqs.javamessaging.acknowledge.NegativeAcknowledger;
import com.amazon.sqs.javamessaging.acknowledge.SQSMessageIdentifier;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SQSMessageConsumer
implements MessageConsumer,
QueueReceiver {
    private static final Log LOG = LogFactory.getLog(SQSMessageConsumer.class);
    public static final int PREFETCH_EXECUTOR_GRACEFUL_SHUTDOWN_TIME = 30;
    protected volatile boolean closed = false;
    private final SQSQueueDestination sqsDestination;
    private final SQSSession parentSQSSession;
    private final SQSSessionCallbackScheduler sqsSessionRunnable;
    private final ExecutorService prefetchExecutor;
    private final SQSMessageConsumerPrefetch sqsMessageConsumerPrefetch;

    SQSMessageConsumer(SQSConnection parentSQSConnection, SQSSession parentSQSSession, SQSSessionCallbackScheduler sqsSessionRunnable, SQSQueueDestination destination, Acknowledger acknowledger, NegativeAcknowledger negativeAcknowledger, ThreadFactory threadFactory) {
        this(parentSQSConnection, parentSQSSession, sqsSessionRunnable, destination, acknowledger, negativeAcknowledger, threadFactory, new SQSMessageConsumerPrefetch(sqsSessionRunnable, acknowledger, negativeAcknowledger, destination, parentSQSConnection.getWrappedAmazonSQSClient(), parentSQSConnection.getNumberOfMessagesToPrefetch()));
    }

    SQSMessageConsumer(SQSConnection parentSQSConnection, SQSSession parentSQSSession, SQSSessionCallbackScheduler sqsSessionRunnable, SQSQueueDestination destination, Acknowledger acknowledger, NegativeAcknowledger negativeAcknowledger, ThreadFactory threadFactory, SQSMessageConsumerPrefetch sqsMessageConsumerPrefetch) {
        this.parentSQSSession = parentSQSSession;
        this.sqsDestination = destination;
        this.sqsSessionRunnable = sqsSessionRunnable;
        this.sqsMessageConsumerPrefetch = sqsMessageConsumerPrefetch;
        this.sqsMessageConsumerPrefetch.setMessageConsumer(this);
        this.prefetchExecutor = Executors.newSingleThreadExecutor(threadFactory);
        this.prefetchExecutor.execute(sqsMessageConsumerPrefetch);
    }

    public Queue getQueue() throws JMSException {
        return this.sqsDestination;
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.sqsMessageConsumerPrefetch.getMessageListener();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.checkClosed();
        this.sqsMessageConsumerPrefetch.setMessageListener(listener);
    }

    public Message receive() throws JMSException {
        return this.sqsMessageConsumerPrefetch.receive();
    }

    public Message receive(long timeout) throws JMSException {
        return this.sqsMessageConsumerPrefetch.receive(timeout);
    }

    public Message receiveNoWait() throws JMSException {
        return this.sqsMessageConsumerPrefetch.receiveNoWait();
    }

    public void close() throws JMSException {
        if (this.closed) {
            return;
        }
        if (this.parentSQSSession.isActiveCallbackSessionThread()) {
            this.sqsSessionRunnable.setConsumerCloseAfterCallback(this);
            return;
        }
        this.doClose();
    }

    void doClose() {
        if (this.closed) {
            return;
        }
        this.sqsMessageConsumerPrefetch.close();
        this.parentSQSSession.removeConsumer(this);
        try {
            if (!this.prefetchExecutor.isShutdown()) {
                LOG.info((Object)"Shutting down ConsumerPrefetch executor");
                this.prefetchExecutor.shutdown();
            }
            this.parentSQSSession.waitForConsumerCallbackToComplete(this);
            if (!this.prefetchExecutor.awaitTermination(30L, TimeUnit.SECONDS)) {
                LOG.warn((Object)"Can't terminate executor service ConsumerPrefetch after 30 seconds, some running threads will be shutdown immediately");
                this.prefetchExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Interrupted while closing the consumer.", (Throwable)e);
        }
        this.closed = true;
    }

    boolean isClosed() {
        return this.closed;
    }

    public String getMessageSelector() throws JMSException {
        throw new JMSException("Unsupported Method");
    }

    protected void stopPrefetch() {
        if (!this.closed) {
            this.sqsMessageConsumerPrefetch.stop();
        }
    }

    protected void startPrefetch() {
        if (!this.closed) {
            this.sqsMessageConsumerPrefetch.start();
        }
    }

    private void checkClosed() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("Consumer is closed");
        }
    }

    List<SQSMessageIdentifier> purgePrefetchedMessagesWithGroups(Set<String> affectedGroups) throws JMSException {
        return this.sqsMessageConsumerPrefetch.purgePrefetchedMessagesWithGroups(affectedGroups);
    }
}

