/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.registry.consul.configuration;

import cn.ponfee.scheduler.core.base.Supervisor;
import cn.ponfee.scheduler.core.base.Worker;
import cn.ponfee.scheduler.registry.SupervisorRegistry;
import cn.ponfee.scheduler.registry.WorkerRegistry;
import cn.ponfee.scheduler.registry.consul.ConsulServerRegistry;
import cn.ponfee.scheduler.registry.consul.ConsulSupervisorRegistry;
import cn.ponfee.scheduler.registry.consul.ConsulWorkerRegistry;
import cn.ponfee.scheduler.registry.consul.configuration.ConsulProperties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ConsulServerRegistry.class})
public class ConsulServerRegistryConfigure {

    @Configuration(proxyBeanMethods=false)
    @AutoConfigureOrder(value=0x7FFFFFFF)
    @DependsOn(value={"currentSupervisor"})
    @ConditionalOnBean(value={Worker.class})
    public static class ConsulWorkerRegistryConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public WorkerRegistry workerRegistry(@Value(value="${distributed.scheduler.namespace:}") String namespace, ConsulProperties props) {
            return new ConsulWorkerRegistry(namespace, props.getHost(), props.getPort(), props.getToken());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @AutoConfigureOrder(value=0x7FFFFFFF)
    @DependsOn(value={"currentWorker"})
    @ConditionalOnBean(value={Supervisor.class})
    public static class ConsulSupervisorRegistryConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public SupervisorRegistry supervisorRegistry(@Value(value="${distributed.scheduler.namespace:}") String namespace, ConsulProperties props) {
            return new ConsulSupervisorRegistry(namespace, props.getHost(), props.getPort(), props.getToken());
        }
    }
}

