/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.registry.consul;

import cn.ponfee.scheduler.common.base.exception.Throwables;
import cn.ponfee.scheduler.common.concurrent.NamedThreadFactory;
import cn.ponfee.scheduler.common.concurrent.Threads;
import cn.ponfee.scheduler.common.util.ObjectUtils;
import cn.ponfee.scheduler.core.base.Server;
import cn.ponfee.scheduler.registry.ServerRegistry;
import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.agent.model.NewService;
import com.ecwid.consul.v1.health.HealthServicesRequest;
import com.ecwid.consul.v1.health.model.HealthService;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public abstract class ConsulServerRegistry<R extends Server, D extends Server>
extends ServerRegistry<R, D> {
    private static final int WAIT_TIME_SECONDS = 60;
    private static final int CHECK_PASS_INTERVAL_SECONDS = 2;
    private static final String CHECK_TTL_SECONDS = "16s";
    private static final String DEREGISTER_TIME_SECONDS = "20s";
    private final ConsulClient client;
    private final String token;
    private final ScheduledExecutorService consulTtlCheckExecutor;
    private final ConsulSubscriberThread consulSubscriberThread;

    protected ConsulServerRegistry(String namespace, String host, int port, String token) {
        super(namespace, ':');
        this.client = new ConsulClient(host, port);
        this.token = token;
        int period = Math.max(2, 1);
        this.consulTtlCheckExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("consul_server_registry", true));
        this.consulTtlCheckExecutor.scheduleWithFixedDelay(this::checkPass, period, period, TimeUnit.SECONDS);
        this.consulSubscriberThread = new ConsulSubscriberThread(-1L);
        this.consulSubscriberThread.start();
    }

    public final boolean isConnected() {
        return this.client.getAgentSelf() != null;
    }

    public final void register(R server) {
        if (this.closed) {
            return;
        }
        NewService newService = this.createService(server);
        if (this.token == null) {
            this.client.agentServiceRegister(newService);
        } else {
            this.client.agentServiceRegister(newService, this.token);
        }
        this.registered.add(server);
        this.log.info("Consul server registered: {} - {}", (Object)this.registryRole.name(), server);
    }

    public final void deregister(R server) {
        try {
            this.registered.remove(server);
            String serverId = this.buildServiceId(server);
            if (this.token == null) {
                this.client.agentServiceDeregister(serverId);
            } else {
                this.client.agentServiceDeregister(serverId, this.token);
            }
            this.log.info("Consul Server deregister: {} - {}", (Object)this.registryRole.name(), server);
        }
        catch (Exception e) {
            this.log.error("Consul server deregister error.", (Throwable)e);
        }
    }

    public void close() {
        this.closed = true;
        if (!this.close.compareAndSet(false, true)) {
            this.log.warn("Repeat call close method\n{}", (Object)ObjectUtils.getStackTrace());
            return;
        }
        Throwables.caught(this.consulTtlCheckExecutor::shutdownNow);
        this.registered.forEach(this::deregister);
        this.registered.clear();
        Throwables.caught(() -> Threads.stopThread((Thread)this.consulSubscriberThread, (int)0, (long)0L, (long)100L));
        super.close();
    }

    private String buildServiceId(R server) {
        return this.registryRootPath + this.separator + server.serialize();
    }

    private NewService createService(R server) {
        NewService service = new NewService();
        service.setName(this.registryRootPath);
        service.setId(this.buildServiceId(server));
        service.setAddress(server.getHost());
        service.setPort(Integer.valueOf(server.getPort()));
        service.setCheck(ConsulServerRegistry.createCheck());
        service.setTags(null);
        service.setMeta(null);
        return service;
    }

    private static NewService.Check createCheck() {
        NewService.Check check = new NewService.Check();
        check.setTtl(CHECK_TTL_SECONDS);
        check.setDeregisterCriticalServiceAfter(DEREGISTER_TIME_SECONDS);
        return check;
    }

    private void checkPass() {
        if (this.closed) {
            return;
        }
        for (Server server : this.registered) {
            String checkId = this.buildServiceId(server);
            try {
                if (this.token == null) {
                    this.client.agentCheckPass("service:" + checkId);
                } else {
                    this.client.agentCheckPass("service:" + checkId, null, this.token);
                }
                this.log.debug("check pass for server: {} with check id {}", (Object)server, (Object)checkId);
            }
            catch (Throwable t) {
                this.log.warn("fail to check pass for server: " + server + ", check id is: " + checkId, t);
            }
        }
    }

    private synchronized void doRefreshDiscoveryServers(List<HealthService> healthServices) {
        List servers;
        if (CollectionUtils.isEmpty(healthServices)) {
            this.log.error("Not discovered available {} from consul.", (Object)this.discoveryRole.name());
            servers = Collections.emptyList();
        } else {
            servers = healthServices.stream().map(HealthService::getService).filter(Objects::nonNull).map(s -> s.getId().substring(this.discoveryRootPath.length() + 1)).map(s -> this.discoveryRole.deserialize(s)).collect(Collectors.toList());
        }
        this.refreshDiscoveredServers(servers);
    }

    private class ConsulSubscriberThread
    extends Thread {
        private long lastConsulIndex;

        private ConsulSubscriberThread(long initConsulIndex) {
            this.lastConsulIndex = initConsulIndex;
            super.setDaemon(true);
            super.setName("consul_subscriber_thread");
        }

        @Override
        public void run() {
            while (!ConsulServerRegistry.this.closed) {
                try {
                    Response<List<HealthService>> response = this.getDiscoveryServers(this.lastConsulIndex, 60L);
                    Long currentIndex = response.getConsulIndex();
                    if (currentIndex == null || currentIndex <= this.lastConsulIndex) continue;
                    this.lastConsulIndex = currentIndex;
                    ConsulServerRegistry.this.doRefreshDiscoveryServers((List)response.getValue());
                }
                catch (Throwable t) {
                    ConsulServerRegistry.this.log.error("Get consul health services occur error.", t);
                    Threads.interruptIfNecessary((Throwable)t);
                }
            }
        }

        private Response<List<HealthService>> getDiscoveryServers(long index, long waitTime) {
            HealthServicesRequest request = HealthServicesRequest.newBuilder().setQueryParams(new QueryParams(waitTime, index)).setPassing(true).setToken(ConsulServerRegistry.this.token).build();
            return ConsulServerRegistry.this.client.getHealthServices(ConsulServerRegistry.this.discoveryRootPath, request);
        }
    }
}

