/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.dispatch.redis.configuration;

import cn.ponfee.scheduler.common.base.TimingWheel;
import cn.ponfee.scheduler.core.base.Supervisor;
import cn.ponfee.scheduler.core.base.Worker;
import cn.ponfee.scheduler.core.param.ExecuteParam;
import cn.ponfee.scheduler.dispatch.TaskDispatcher;
import cn.ponfee.scheduler.dispatch.TaskReceiver;
import cn.ponfee.scheduler.dispatch.redis.RedisTaskDispatcher;
import cn.ponfee.scheduler.dispatch.redis.RedisTaskReceiver;
import cn.ponfee.scheduler.registry.Discovery;
import cn.ponfee.scheduler.registry.SupervisorRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.lang.Nullable;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={StringRedisTemplate.class})
public class RedisTaskDispatchingConfiguration {

    @Configuration(proxyBeanMethods=false)
    @AutoConfigureOrder(value=0x7FFFFFFF)
    @DependsOn(value={"currentSupervisor"})
    @ConditionalOnBean(value={Worker.class})
    @ConditionalOnSingleCandidate(value=TimingWheel.class)
    public static class RedisTaskReceiverConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public TaskReceiver taskReceiver(Worker worker, TimingWheel<ExecuteParam> timingWheel, StringRedisTemplate stringRedisTemplate) {
            return new RedisTaskReceiver(worker, timingWheel, (RedisTemplate<String, String>)stringRedisTemplate);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @AutoConfigureOrder(value=0x7FFFFFFF)
    @DependsOn(value={"currentWorker"})
    @ConditionalOnBean(value={Supervisor.class})
    public static class RedisTaskDispatcherConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public TaskDispatcher taskDispatcher(SupervisorRegistry discoveryWorker, @Nullable TimingWheel<ExecuteParam> timingWheel, StringRedisTemplate stringRedisTemplate) {
            return new RedisTaskDispatcher((Discovery<Worker>)discoveryWorker, timingWheel, (RedisTemplate<String, String>)stringRedisTemplate);
        }
    }
}

