/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stochprocess;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.doublealgo.Sorting;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.SingularValueDecomposition;
import umontreal.ssj.probdist.NormalDist;
import umontreal.ssj.randvar.NormalGen;
import umontreal.ssj.rng.RandomStream;
import umontreal.ssj.stochprocess.MultivariateBrownianMotion;

public class MultivariateBrownianMotionPCA
extends MultivariateBrownianMotion {
    protected DoubleMatrix2D C;
    protected DoubleMatrix2D BC;
    protected DoubleMatrix2D sortedBC;
    protected DoubleMatrix2D copyBC;
    protected DoubleMatrix2D PcovZ;
    protected DoubleMatrix2D PC;
    protected double[] z;
    protected double[] zz;
    protected double[] zzz;
    protected int[] eigenIndex;
    protected boolean decompPCA;

    public MultivariateBrownianMotionPCA(int c, double[] x0, double[] mu, double[] sigma, double[][] corrZ, RandomStream stream) {
        this.gen = new NormalGen(stream, new NormalDist());
        this.setParams(c, x0, mu, sigma, corrZ);
    }

    public MultivariateBrownianMotionPCA(int c, double[] x0, double[] mu, double[] sigma, double[][] corrZ, NormalGen gen) {
        this.gen = gen;
        this.setParams(c, x0, mu, sigma, corrZ);
    }

    @Override
    public void setParams(int c, double[] x0, double[] mu, double[] sigma, double[][] corrZ) {
        this.decompPCA = false;
        super.setParams(c, x0, mu, sigma, corrZ);
    }

    @Override
    public double[] generatePath() {
        double[] u = new double[this.c * this.d];
        for (int i = 0; i < this.c * this.d; ++i) {
            u[i] = this.gen.nextDouble();
        }
        return this.generatePath(u);
    }

    @Override
    public double[] generatePath(double[] uniform01) {
        int k;
        double sum;
        int i;
        int j;
        if (!this.decompPCA) {
            this.init();
        }
        for (j = 0; j < this.c * this.d; ++j) {
            this.z[j] = uniform01[j] * this.BC.getQuick(j, 0);
        }
        for (j = 0; j < this.c * this.d; ++j) {
            this.zz[j] = this.z[(int)this.BC.getQuick(j, 1)];
        }
        for (j = 0; j < this.d; ++j) {
            for (i = 0; i < this.c; ++i) {
                sum = 0.0;
                for (k = 0; k < this.c; ++k) {
                    sum += this.PcovZ.getQuick(i, k) * this.zz[j * this.c + k];
                }
                this.zzz[j * this.c + i] = sum;
            }
        }
        for (j = 0; j < this.d; ++j) {
            for (i = 0; i < this.c; ++i) {
                sum = 0.0;
                for (k = 0; k < this.d; ++k) {
                    sum += this.PC.getQuick(j, k) * this.zzz[this.c * k + i];
                }
                this.path[(j + 1) * this.c + i] = sum + this.mu[i] * (this.t[j + 1] - this.t[0]) + this.x0[i];
            }
        }
        this.observationIndex = this.observationCounter = this.d;
        return this.path;
    }

    protected DoubleMatrix2D decompPCA(DoubleMatrix2D Sigma, double[] eigenValues) {
        SingularValueDecomposition sv = new SingularValueDecomposition(Sigma);
        DoubleMatrix2D D = sv.getS();
        for (int i = 0; i < D.rows(); ++i) {
            D.setQuick(i, i, Math.sqrt(D.getQuick(i, i)));
            eigenValues[i] = D.getQuick(i, i);
        }
        DoubleMatrix2D P = sv.getV();
        return P;
    }

    @Override
    protected void init() {
        int i;
        int j;
        super.init();
        this.z = new double[this.c * this.d];
        this.zz = new double[this.c * this.d];
        this.zzz = new double[this.c * this.d];
        double[] lambdaC = new double[this.d];
        double[] etaB = new double[this.c];
        this.BC = new DenseDoubleMatrix2D(this.c * this.d, 2);
        this.sortedBC = new DenseDoubleMatrix2D(this.c * this.d, 2);
        this.PC = new DenseDoubleMatrix2D(this.d, this.d);
        this.PcovZ = new DenseDoubleMatrix2D(this.c, this.c);
        this.C = new DenseDoubleMatrix2D(this.d, this.d);
        for (j = 0; j < this.d; ++j) {
            for (i = j; i < this.d; ++i) {
                this.C.setQuick(j, i, this.t[j + 1]);
                this.C.setQuick(i, j, this.t[j + 1]);
            }
        }
        this.PC = this.decompPCA(this.C, lambdaC);
        this.PcovZ = this.decompPCA(this.covZ, etaB);
        for (j = 0; j < this.d; ++j) {
            for (i = 0; i < this.c; ++i) {
                this.BC.setQuick(this.c * j + i, 0, lambdaC[j] * etaB[i]);
                this.BC.setQuick(this.c * j + i, 1, (double)(this.c * j + i));
            }
        }
        this.sortedBC = Sorting.quickSort.sort(this.BC, 0);
        DoubleMatrix2D copyBC = this.sortedBC.copy();
        for (i = 0; i < this.c * this.d; ++i) {
            this.BC.setQuick(i, 0, copyBC.getQuick(this.c * this.d - 1 - i, 0));
            this.BC.setQuick(i, 1, copyBC.getQuick(this.c * this.d - 1 - i, 1));
        }
        this.decompPCA = true;
    }
}

