/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stat.density;

import umontreal.ssj.stat.density.DensityEstimatorDoubleArray;

public abstract class ConditionalDensityEstimator
extends DensityEstimatorDoubleArray {
    @Override
    public void setData(double[][] data) {
        this.data = new double[data.length][];
        for (int i = 0; i < data.length; ++i) {
            this.data[i] = new double[data[i].length];
            for (int j = 0; j < data[i].length; ++j) {
                this.data[i][j] = data[i][j];
            }
        }
    }

    @Override
    public double evalDensity(double x) {
        double dens = 0.0;
        int N = this.data.length;
        double Ninv = 1.0 / (double)N;
        for (int i = 0; i < N; ++i) {
            dens += this.evalEstimator(x, this.data[i]);
            dens *= Ninv;
        }
        return dens;
    }

    @Override
    public double[] evalDensity(double[] x) {
        int k = x.length;
        double[] dens = new double[k];
        int N = this.data.length;
        double Ninv = 1.0 / (double)N;
        int j = 0;
        while (j < k) {
            dens[j] = 0.0;
            for (int i = 0; i < N; ++i) {
                int n = j;
                dens[n] = dens[n] + this.evalEstimator(x[j], this.data[i]);
            }
            int n = j++;
            dens[n] = dens[n] * Ninv;
        }
        return dens;
    }

    @Override
    public double[] evalDensity(double[] evalPoints, double[][] data) {
        this.setData(data);
        return this.evalDensity(evalPoints);
    }

    public abstract double evalEstimator(double var1, double[] var3);

    @Override
    public String toString() {
        return "Conditional Density Estimator";
    }
}

