/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.latnetbuilder.weights;

import umontreal.ssj.latnetbuilder.weights.OrderDependentWeights;
import umontreal.ssj.latnetbuilder.weights.ProductWeights;
import umontreal.ssj.latnetbuilder.weights.SingletonWeightComparable;
import umontreal.ssj.latnetbuilder.weights.Weights;

public class PODWeights
extends Weights {
    ProductWeights productWeights;
    OrderDependentWeights orderDependentWeights;

    public PODWeights(ProductWeights pWeights, OrderDependentWeights odWeights) {
        this.productWeights = pWeights;
        this.orderDependentWeights = odWeights;
    }

    public PODWeights(ProductWeights pWeights) {
        this.productWeights = pWeights;
        this.orderDependentWeights = new OrderDependentWeights();
    }

    public PODWeights(OrderDependentWeights odWeights) {
        this.productWeights = new ProductWeights();
        this.orderDependentWeights = odWeights;
    }

    public PODWeights() {
        this.productWeights = new ProductWeights();
        this.orderDependentWeights = new OrderDependentWeights();
    }

    public ProductWeights getProductWeights() {
        return this.productWeights;
    }

    public void setProductWeights(ProductWeights productWeights) {
        this.productWeights = productWeights;
    }

    public OrderDependentWeights getOrderDependentWeights() {
        return this.orderDependentWeights;
    }

    public void setOrderDependentWeights(OrderDependentWeights orderDependentWeights) {
        this.orderDependentWeights = orderDependentWeights;
    }

    public void addOrderDependentWeight(SingletonWeightComparable<Integer> weight) {
        this.orderDependentWeights.add(weight);
    }

    public void addOrderDependentWeight(int ord, double weight) {
        this.orderDependentWeights.add(ord, weight);
    }

    public void addProductWeight(SingletonWeightComparable<Integer> weight) {
        this.productWeights.add(weight);
    }

    public void addProductWeight(int index, double weight) {
        this.productWeights.add(index, weight);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("");
        sb.append("POD weights:\n");
        sb.append(this.productWeights.toString() + "\n");
        sb.append(this.orderDependentWeights.toString());
        return sb.toString();
    }

    @Override
    public String toLatNetBuilder() {
        StringBuffer sb = new StringBuffer("");
        sb.append("POD:" + this.orderDependentWeights.getDefaultWeight());
        if (this.orderDependentWeights.weights.size() > 0) {
            sb.append(":");
            sb.append(this.orderDependentWeights.printBody());
        }
        sb.append(":" + this.productWeights.getDefaultWeight());
        if (this.productWeights.weights.size() > 0) {
            sb.append(":");
            sb.append(this.productWeights.printBody());
        }
        return sb.toString();
    }
}

