/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stat;

import umontreal.ssj.stat.TallyHistogram;

public class ScaledHistogram {
    protected int numBins;
    protected double m_h;
    protected double m_a;
    protected double m_b;
    protected double[] height;
    protected double integral;

    private ScaledHistogram() {
    }

    public ScaledHistogram(double a, double b, int numBins) {
        this.init(a, b, numBins);
    }

    public ScaledHistogram(TallyHistogram hist, double integral) {
        this.init(hist, integral);
    }

    public void init(double a, double b, int numBins) {
        if (b <= a) {
            throw new IllegalArgumentException("   b <= a");
        }
        this.numBins = numBins;
        this.m_h = (b - a) / (double)numBins;
        this.m_a = a;
        this.m_b = b;
        this.height = new double[numBins];
        for (int i = 0; i < numBins; ++i) {
            this.height[i] = 0.0;
        }
        this.integral = 0.0;
    }

    public void init(TallyHistogram hist, double integral) {
        this.m_a = hist.getA();
        this.m_b = hist.getB();
        this.m_h = hist.getH();
        this.numBins = hist.numBins;
        this.height = new double[this.numBins];
        this.integral = integral;
        int[] count = hist.getCounters();
        double scaleFactor = integral / ((double)hist.numberObs() * this.m_h);
        for (int i = 0; i < this.numBins; ++i) {
            this.height[i] = (double)count[i] * scaleFactor;
        }
    }

    public void init() {
        for (int i = 0; i < this.numBins; ++i) {
            this.height[i] = 0.0;
        }
    }

    public void rescale(double integral) {
        double scaleFactor = integral / this.integral;
        int i = 0;
        while (i < this.numBins) {
            int n = i++;
            this.height[n] = this.height[n] * scaleFactor;
        }
        this.integral = integral;
    }

    public ScaledHistogram averageShiftedHistogram(int r) {
        ScaledHistogram image = this.clone();
        double[] heightNew = image.getHeights();
        double rscale = 1.0 / (double)(r * r);
        double sum = 0.0;
        for (int k = 0; k < this.numBins; ++k) {
            heightNew[k] = (double)r * this.height[k];
            for (int ell = 1; ell < r; ++ell) {
                if (k - ell >= 0) {
                    int n = k;
                    heightNew[n] = heightNew[n] + (double)(r - ell) * this.height[k - ell];
                }
                if (k + ell >= this.numBins) continue;
                int n = k;
                heightNew[n] = heightNew[n] + (double)(r - ell) * this.height[k + ell];
            }
            int n = k;
            heightNew[n] = heightNew[n] * rscale;
            sum += heightNew[k];
        }
        image.height = heightNew;
        image.integral = sum * this.m_h;
        return image;
    }

    public ScaledHistogram averageShiftedHistogramTrunc(int r) {
        ScaledHistogram image = this.clone();
        double[] heightNew = image.getHeights();
        double sum = 0.0;
        for (int k = 0; k < this.numBins; ++k) {
            heightNew[k] = (double)r * this.height[k];
            int weight = r;
            for (int ell = 1; ell < r; ++ell) {
                if (k - ell >= 0) {
                    int n = k;
                    heightNew[n] = heightNew[n] + (double)(r - ell) * this.height[k - ell];
                    weight += r - ell;
                }
                if (k + ell >= this.numBins) continue;
                int n = k;
                heightNew[n] = heightNew[n] + (double)(r - ell) * this.height[k + ell];
                weight += r - ell;
            }
            int n = k;
            heightNew[n] = heightNew[n] * (1.0 / (double)weight);
            sum += heightNew[k];
        }
        image.height = heightNew;
        image.integral = sum * this.m_h;
        return image;
    }

    public ScaledHistogram averageShiftedHistogram(int r, double[] w) {
        ScaledHistogram image = this.clone();
        double[] heightNew = image.getHeights();
        double weight = w[0];
        for (int ell = 1; ell < r; ++ell) {
            weight += 2.0 * w[ell];
        }
        double rscale = 1.0 / weight;
        double sum = 0.0;
        for (int k = 0; k < this.numBins; ++k) {
            heightNew[k] = w[0] * this.height[k];
            for (int ell = 1; ell < r; ++ell) {
                if (k - ell >= 0) {
                    int n = k;
                    heightNew[n] = heightNew[n] + w[ell] * this.height[k - ell];
                }
                if (k + ell >= this.numBins) continue;
                int n = k;
                heightNew[n] = heightNew[n] + w[ell] * this.height[k + ell];
            }
            int n = k;
            heightNew[n] = heightNew[n] * rscale;
            sum += heightNew[k];
        }
        image.height = heightNew;
        image.integral = sum * this.m_h;
        return image;
    }

    public ScaledHistogram averageShiftedHistogramTrunc(int r, double[] w) {
        ScaledHistogram image = this.clone();
        double[] heightNew = image.getHeights();
        double sum = 0.0;
        for (int k = 0; k < this.numBins; ++k) {
            heightNew[k] = w[0] * this.height[k];
            double weight = w[0];
            for (int ell = 1; ell < r; ++ell) {
                if (k - ell >= 0) {
                    int n = k;
                    heightNew[n] = heightNew[n] + w[ell] * this.height[k - ell];
                    weight += w[ell];
                }
                if (k + ell >= this.numBins) continue;
                int n = k;
                heightNew[n] = heightNew[n] + w[ell] * this.height[k + ell];
                weight += w[ell];
            }
            int n = k;
            heightNew[n] = heightNew[n] * (1.0 / weight);
            sum += heightNew[k];
        }
        image.height = heightNew;
        image.integral = sum * this.m_h;
        return image;
    }

    public ScaledHistogram averageShiftedHistogram1(int r) {
        int k;
        ScaledHistogram image = this.clone();
        double[] heightNew = image.getHeights();
        double rscale = 1.0 / (double)(r * r);
        double sum = 0.0;
        double[] S1 = new double[this.numBins];
        double[] S2 = new double[this.numBins];
        S1[0] = this.height[0];
        S2[0] = 0.0;
        heightNew[0] = (double)r * S1[0];
        for (int ell = 1; ell <= Math.min(r, this.numBins); ++ell) {
            S2[0] = S2[0] + this.height[ell];
            heightNew[0] = heightNew[0] + (double)(r - ell) * this.height[ell];
        }
        for (k = 2; k <= this.numBins; ++k) {
            S1[k - 1] = S1[k - 2] + this.height[k - 1];
            if (k >= r) {
                int n = k - 1;
                S1[n] = S1[n] - this.height[k - r];
            }
            S2[k - 1] = S2[k - 2] - this.height[k - 1];
            if (k + r < this.numBins) {
                int n = k - 1;
                S2[n] = S2[n] + this.height[k + r - 1];
            }
            heightNew[k - 1] = heightNew[k - 2] + S2[k - 2] - S1[k - 2];
        }
        for (k = 0; k < this.numBins; ++k) {
            int n = k;
            heightNew[n] = heightNew[n] * rscale;
            sum += heightNew[k];
        }
        image.height = heightNew;
        image.integral = sum * this.m_h;
        return image;
    }

    public int getNumBins() {
        return this.numBins;
    }

    public double getA() {
        return this.m_a;
    }

    public double getB() {
        return this.m_b;
    }

    public double[] getHeights() {
        return this.height;
    }

    public double getIntegral() {
        return this.integral;
    }

    public double ISEvsU01() {
        double sum = 0.0;
        for (int j = 0; j < this.numBins; ++j) {
            sum += (this.height[j] - 1.0) * (this.height[j] - 1.0);
        }
        return sum / (double)this.numBins;
    }

    public double ISEvsU01polygonal() {
        double[] w0 = new double[this.numBins];
        for (int j = 0; j < this.numBins; ++j) {
            w0[j] = this.height[j] - 1.0;
        }
        double sum = 0.5 * (w0[0] * w0[0] + w0[this.numBins - 1] * w0[this.numBins - 1]);
        for (int j = 0; j < this.numBins - 2; ++j) {
            double a = w0[j];
            double b = w0[j + 1];
            sum += 0.3333333333333333 * (b * b + a * a + a * b);
        }
        return sum / (double)this.numBins;
    }

    public ScaledHistogram clone() {
        ScaledHistogram image = new ScaledHistogram();
        image.numBins = this.numBins;
        image.m_h = this.m_h;
        image.m_a = this.m_a;
        image.m_b = this.m_b;
        image.height = new double[this.numBins];
        image.integral = this.integral;
        for (int j = 1; j < this.numBins; ++j) {
            image.height[j] = this.height[j];
        }
        return image;
    }
}

