/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvar;

import umontreal.ssj.probdist.PowerDist;
import umontreal.ssj.randvar.RandomVariateGen;
import umontreal.ssj.rng.RandomStream;

public class PowerGen
extends RandomVariateGen {
    private double a;
    private double b;
    private double c;

    public PowerGen(RandomStream s, double a, double b, double c) {
        super(s, new PowerDist(a, b, c));
        this.setParams(a, b, c);
    }

    public PowerGen(RandomStream s, double c) {
        super(s, new PowerDist(0.0, 1.0, c));
        this.setParams(0.0, 1.0, c);
    }

    public PowerGen(RandomStream s, PowerDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getA(), dist.getB(), dist.getC());
        }
    }

    public static double nextDouble(RandomStream s, double a, double b, double c) {
        return PowerDist.inverseF(a, b, c, s.nextDouble());
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getC() {
        return this.c;
    }

    public void setParams(double a, double b, double c) {
        this.a = a;
        this.b = b;
        this.c = c;
    }
}

