/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.charts;

import cern.colt.list.DoubleArrayList;
import java.awt.Container;
import java.awt.Dimension;
import java.util.Formatter;
import java.util.ListIterator;
import java.util.Locale;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.statistics.HistogramBin;
import org.jfree.data.xy.XYDataset;
import umontreal.ssj.charts.Axis;
import umontreal.ssj.charts.CustomHistogramDataset;
import umontreal.ssj.charts.HistogramSeriesCollection;
import umontreal.ssj.charts.XYChart;
import umontreal.ssj.stat.TallyHistogram;
import umontreal.ssj.stat.TallyStore;

public class HistogramChart
extends XYChart {
    protected void init(String title, String XLabel, String YLabel) {
        this.chart = ChartFactory.createXYLineChart((String)title, (String)XLabel, (String)YLabel, (XYDataset)this.dataset.getSeriesCollection(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        ((XYPlot)this.chart.getPlot()).setRenderer(this.dataset.getRenderer());
        this.XAxis = new Axis((NumberAxis)((XYPlot)this.chart.getPlot()).getDomainAxis(), true);
        this.YAxis = new Axis((NumberAxis)((XYPlot)this.chart.getPlot()).getRangeAxis(), false);
        this.setAutoRange(false, true, true, true);
    }

    public HistogramChart() {
        this.dataset = new HistogramSeriesCollection();
        this.init(null, null, null);
    }

    public HistogramChart(String title, String XLabel, String YLabel, double[] ... data) {
        this.dataset = new HistogramSeriesCollection(data);
        this.init(title, XLabel, YLabel);
    }

    public HistogramChart(String title, String XLabel, String YLabel, double[] data, int numPoints) {
        double[] datan = new double[numPoints];
        System.arraycopy(data, 0, datan, 0, numPoints);
        this.dataset = new HistogramSeriesCollection(new double[][]{datan});
        this.init(title, XLabel, YLabel);
    }

    public HistogramChart(String title, String XLabel, String YLabel, DoubleArrayList ... data) {
        this.dataset = new HistogramSeriesCollection(data);
        this.init(title, XLabel, YLabel);
    }

    public HistogramChart(String title, String XLabel, String YLabel, TallyStore ... tallies) {
        this.dataset = new HistogramSeriesCollection(tallies);
        this.init(title, XLabel, YLabel);
    }

    public HistogramChart(String title, String XLabel, String YLabel, CustomHistogramDataset data) {
        this.dataset = new HistogramSeriesCollection(data);
        this.init(title, XLabel, YLabel);
    }

    public HistogramChart(String title, String XLabel, String YLabel, int[] count, double[] bound) {
        if (bound.length != count.length + 1) {
            throw new IllegalArgumentException("bound.length must be equal to count.length + 1");
        }
        int nb = count.length;
        int sum = 0;
        for (int i = 0; i < nb; ++i) {
            sum += count[i];
        }
        double[] data = new double[sum];
        int k = 0;
        for (int i = 0; i < nb; ++i) {
            int j;
            double h = bound[i + 1] - bound[i];
            if (count[i] > 0) {
                h /= (double)count[i];
            }
            if (i == nb - 1) {
                for (j = 0; j < count[i]; ++j) {
                    data[k++] = bound[i + 1] - (double)j * h;
                }
                continue;
            }
            for (j = 0; j < count[i]; ++j) {
                data[k++] = bound[i] + (double)j * h;
            }
        }
        this.dataset = new HistogramSeriesCollection(data, sum);
        this.init(title, XLabel, YLabel);
        ((HistogramSeriesCollection)this.dataset).setBins(0, nb);
    }

    public HistogramChart(String title, String XLabel, String YLabel, TallyHistogram ... tallies) {
        this.dataset = new HistogramSeriesCollection(tallies);
        this.init(title, XLabel, YLabel);
    }

    @Override
    public void setAutoRange(boolean right, boolean top) {
        throw new UnsupportedOperationException("You can't use setAutoRange with HistogramChart class, use setAutoRange().");
    }

    public void setManuelRange(double[] range, boolean right, boolean top) {
        throw new UnsupportedOperationException("You can't use setManuelRange with HistogramChart class, use setManuelRange(range).");
    }

    public HistogramSeriesCollection getSeriesCollection() {
        return (HistogramSeriesCollection)this.dataset;
    }

    public void setSeriesCollection(HistogramSeriesCollection dataset) {
        this.dataset = dataset;
    }

    @Override
    public void setTicksSynchro(int s) {
        if (((CustomHistogramDataset)this.dataset.getSeriesCollection()).getBinWidth(s) == -1.0) {
            DoubleArrayList newTicks = new DoubleArrayList();
            ListIterator binsIter = ((HistogramSeriesCollection)this.dataset).getBins(s).listIterator();
            boolean i = false;
            HistogramBin prec = (HistogramBin)binsIter.next();
            newTicks.add(prec.getStartBoundary());
            double var = prec.getEndBoundary();
            newTicks.add(var);
            while (binsIter.hasNext()) {
                HistogramBin temp = (HistogramBin)binsIter.next();
                if (temp.getStartBoundary() != var) {
                    var = temp.getStartBoundary();
                    newTicks.add(var);
                    continue;
                }
                if (temp.getEndBoundary() == var) continue;
                var = temp.getEndBoundary();
                newTicks.add(var);
            }
            this.XAxis.setLabels(newTicks.elements());
        } else {
            int n = ((HistogramSeriesCollection)this.dataset).getBins(s).size();
            if (n > 10) {
                n = 10;
                double[] B = ((HistogramSeriesCollection)this.dataset).getDomainBounds();
                double w = (B[1] - B[0]) / (double)n;
                this.XAxis.setLabels(w);
            } else {
                this.XAxis.setLabels(((CustomHistogramDataset)this.dataset.getSeriesCollection()).getBinWidth(s));
            }
        }
    }

    @Override
    public JFrame view(int width, int height) {
        JFrame myFrame = this.chart.getTitle() != null ? new JFrame("HistogramChart from SSJ: " + this.chart.getTitle().getText()) : new JFrame("HistogramChart from SSJ");
        ChartPanel chartPanel = new ChartPanel(this.chart);
        chartPanel.setPreferredSize(new Dimension(width, height));
        myFrame.setContentPane((Container)chartPanel);
        myFrame.pack();
        myFrame.setDefaultCloseOperation(2);
        myFrame.setLocationRelativeTo(null);
        myFrame.setVisible(true);
        return myFrame;
    }

    @Override
    public String toLatex(double width, double height) {
        double[] save = new double[4];
        if (this.dataset.getSeriesCollection().getSeriesCount() == 0) {
            throw new IllegalArgumentException("Empty chart");
        }
        if (this.YAxis.getTwinAxisPosition() < 0.0) {
            this.YAxis.setTwinAxisPosition(0.0);
        }
        double XScale = this.computeXScale(this.XAxis.getTwinAxisPosition());
        double YScale = this.computeYScale(this.YAxis.getTwinAxisPosition());
        double xunit = width / (Math.max(this.XAxis.getAxis().getRange().getUpperBound(), this.XAxis.getTwinAxisPosition()) * XScale - Math.min(this.XAxis.getAxis().getRange().getLowerBound(), this.XAxis.getTwinAxisPosition()) * XScale);
        double yunit = height / (Math.max(this.YAxis.getAxis().getRange().getUpperBound(), this.YAxis.getTwinAxisPosition()) * YScale - Math.min(this.YAxis.getAxis().getRange().getLowerBound(), this.YAxis.getTwinAxisPosition()) * YScale);
        Formatter formatter = new Formatter(Locale.US);
        if (this.latexDocFlag) {
            formatter.format("\\documentclass[12pt]{article}%n%n", new Object[0]);
            formatter.format("\\usepackage{tikz}%n\\usetikzlibrary{plotmarks}%n\\begin{document}%n%n", new Object[0]);
        }
        if (this.chart.getTitle() != null) {
            formatter.format("%% PGF/TikZ picture from SSJ: %s%n", this.chart.getTitle().getText());
        } else {
            formatter.format("%% PGF/TikZ picture from SSJ %n", new Object[0]);
        }
        formatter.format("%% XScale = %s,  YScale = %s,  XShift = %s,  YShift = %s%n", XScale, YScale, this.XAxis.getTwinAxisPosition(), this.YAxis.getTwinAxisPosition());
        formatter.format("%% Therefore, thisFileXValue = (originalSeriesXValue+XShift)*XScale%n", new Object[0]);
        formatter.format("%%        and thisFileYValue = (originalSeriesYValue+YShift)*YScale%n%n", new Object[0]);
        if (this.chart.getTitle() != null) {
            formatter.format("\\begin{figure}%n", new Object[0]);
        }
        formatter.format("\\begin{center}%n", new Object[0]);
        formatter.format("\\begin{tikzpicture}[x=%scm, y=%scm]%n", xunit, yunit);
        formatter.format("\\footnotesize%n", new Object[0]);
        if (this.grid) {
            formatter.format("\\draw[color=lightgray] (%s, %s) grid[xstep = %s, ystep=%s] (%s, %s);%n", (Math.min(this.XAxis.getAxis().getRange().getLowerBound(), this.XAxis.getTwinAxisPosition()) - this.XAxis.getTwinAxisPosition()) * XScale, (Math.min(this.YAxis.getAxis().getRange().getLowerBound(), this.YAxis.getTwinAxisPosition()) - this.YAxis.getTwinAxisPosition()) * YScale, this.xstepGrid * XScale, this.ystepGrid * YScale, (Math.max(this.XAxis.getAxis().getRange().getUpperBound(), this.XAxis.getTwinAxisPosition()) - this.XAxis.getTwinAxisPosition()) * XScale, (Math.max(this.YAxis.getAxis().getRange().getUpperBound(), this.YAxis.getTwinAxisPosition()) - this.YAxis.getTwinAxisPosition()) * YScale);
        }
        this.setTick0Flags();
        formatter.format("%s", this.XAxis.toLatex(XScale));
        formatter.format("%s", this.YAxis.toLatex(YScale));
        formatter.format("%s", this.dataset.toLatex(XScale, YScale, this.XAxis.getTwinAxisPosition(), this.YAxis.getTwinAxisPosition(), this.XAxis.getAxis().getLowerBound(), this.XAxis.getAxis().getUpperBound(), this.YAxis.getAxis().getLowerBound(), this.YAxis.getAxis().getUpperBound()));
        formatter.format("\\end{tikzpicture}%n", new Object[0]);
        formatter.format("\\end{center}%n", new Object[0]);
        if (this.chart.getTitle() != null) {
            formatter.format("\\caption{", new Object[0]);
            formatter.format(this.chart.getTitle().getText(), new Object[0]);
            formatter.format("}%n\\end{figure}%n", new Object[0]);
        }
        if (this.latexDocFlag) {
            formatter.format("\\end{document}%n", new Object[0]);
        }
        return formatter.toString();
    }
}

