/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.util.io;

import java.lang.reflect.Array;

public class DataField {
    protected String label;
    protected Object data;
    protected int effectiveLength;

    public DataField(String label, Object data) {
        this(label, data, -1);
    }

    public DataField(String label, Object data, int effectiveLength) {
        this.label = label;
        this.data = data;
        this.effectiveLength = effectiveLength;
    }

    public String getLabel() {
        return this.label;
    }

    public Class getType() {
        return this.data.getClass();
    }

    public boolean isAtomic() {
        return !this.isArray();
    }

    public boolean isArray() {
        return this.data.getClass().isArray();
    }

    public boolean isArray2D() {
        return this.isArray() && Array.get(this.data, 0).getClass().isArray();
    }

    public int getArrayLength() {
        if (!this.isArray()) {
            return -1;
        }
        if (this.effectiveLength < 0) {
            return Array.getLength(this.data);
        }
        return this.effectiveLength;
    }

    public boolean isString() {
        return this.data instanceof String;
    }

    public boolean isInt() {
        return this.data instanceof Integer;
    }

    public boolean isFloat() {
        return this.data instanceof Float;
    }

    public boolean isDouble() {
        return this.data instanceof Double;
    }

    public String asString() {
        return this.data instanceof String ? (String)this.data : null;
    }

    public int asInt() {
        return this.data instanceof Integer ? (Integer)this.data : 0;
    }

    public float asFloat() {
        return this.data instanceof Float ? ((Float)this.data).floatValue() : 0.0f;
    }

    public double asDouble() {
        return this.data instanceof Double ? (Double)this.data : 0.0;
    }

    public String[] asStringArray() {
        return this.data instanceof String[] ? (String[])this.data : null;
    }

    public int[] asIntArray() {
        return this.data instanceof int[] ? (int[])this.data : null;
    }

    public float[] asFloatArray() {
        return this.data instanceof float[] ? (float[])this.data : null;
    }

    public double[] asDoubleArray() {
        return this.data instanceof double[] ? (double[])this.data : null;
    }

    public String[][] asStringArray2D() {
        return this.data instanceof String[][] ? (String[][])this.data : (String[][])null;
    }

    public int[][] asIntArray2D() {
        return this.data instanceof int[][] ? (int[][])this.data : (int[][])null;
    }

    public float[][] asFloatArray2D() {
        return this.data instanceof float[][] ? (float[][])this.data : (float[][])null;
    }

    public double[][] asDoubleArray2D() {
        return this.data instanceof double[][] ? (double[][])this.data : (double[][])null;
    }

    public Object asObject() {
        return this.data;
    }
}

