/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.util;

import umontreal.ssj.util.PrintfFormat;

public class TableFormat {
    public static final int PLAIN = 0;
    public static final int MATHEMATICA = 1;
    public static final int MATLAB = 2;
    private static int Style = 0;
    private static char OuvrantMat = (char)32;
    private static char FermantMat = (char)32;
    private static char OuvrantVec = (char)32;
    private static char FermantVec = (char)32;
    private static char SepareVec = (char)32;
    private static char SepareElem = (char)32;

    private TableFormat() {
    }

    public static String format(int[] V, int n1, int n2, int k, int p) {
        StringBuffer sb = new StringBuffer();
        if (k > 1) {
            sb.append("Elements  " + n1 + "  to  " + n2 + PrintfFormat.NEWLINE + PrintfFormat.NEWLINE);
            for (int i = n1; i <= n2; ++i) {
                sb.append(PrintfFormat.d(p, V[i]));
                if ((i + 1 - n1) % k != 0) continue;
                sb.append(PrintfFormat.NEWLINE);
            }
            sb.append(PrintfFormat.NEWLINE);
        } else {
            sb.append(PrintfFormat.NEWLINE + " Index        Element" + PrintfFormat.NEWLINE);
            for (int i = n1; i <= n2; ++i) {
                sb.append(PrintfFormat.d(6, i) + "   " + PrintfFormat.d(12, V[i]) + PrintfFormat.NEWLINE);
            }
        }
        sb.append(PrintfFormat.NEWLINE);
        return sb.toString();
    }

    public static String format(double[] V, int n1, int n2, int k, int p1, int p2, int p3) {
        StringBuffer sb = new StringBuffer();
        if (k > 1) {
            sb.append("Elements  " + n1 + "  to  " + n2 + PrintfFormat.NEWLINE + PrintfFormat.NEWLINE);
            for (int i = n1; i <= n2; ++i) {
                sb.append(PrintfFormat.format(p1, p2, p3, V[i]));
                if ((i + 1 - n1) % k != 0) continue;
                sb.append(PrintfFormat.NEWLINE);
            }
            sb.append(PrintfFormat.NEWLINE);
        } else {
            sb.append(PrintfFormat.NEWLINE + " Index            Element" + PrintfFormat.NEWLINE);
            for (int i = n1; i <= n2; ++i) {
                sb.append(PrintfFormat.d(6, i) + "   " + PrintfFormat.format(p1, p2, p3, V[i]) + PrintfFormat.NEWLINE);
            }
        }
        sb.append(PrintfFormat.NEWLINE);
        return sb.toString();
    }

    private static void fixeDelim(int style) {
        Style = style;
        switch (style) {
            case 1: {
                OuvrantMat = (char)123;
                FermantMat = (char)125;
                OuvrantVec = (char)123;
                FermantVec = (char)125;
                SepareVec = (char)44;
                SepareElem = (char)44;
                break;
            }
            case 2: {
                OuvrantMat = (char)91;
                FermantMat = (char)93;
                OuvrantVec = (char)32;
                FermantVec = (char)32;
                SepareVec = (char)32;
                SepareElem = (char)32;
                break;
            }
            default: {
                OuvrantMat = (char)32;
                FermantMat = (char)32;
                OuvrantVec = (char)32;
                FermantVec = (char)32;
                SepareVec = (char)32;
                SepareElem = (char)32;
            }
        }
    }

    @Deprecated
    public static String format(int[][] Mat, int i1, int i2, int j1, int j2, int w, int p, int style, String Name) {
        return TableFormat.format(Mat, i1, i2, j1, j2, w, style, Name);
    }

    public static String format(double[][] Mat, int i1, int i2, int j1, int j2, int w, int p, int style, String Name) {
        TableFormat.fixeDelim(style);
        StringBuffer sb = new StringBuffer();
        if (Name.length() > 0) {
            sb.append(Name + " = ");
        }
        double prec = Math.pow(10.0, p);
        sb.append(OuvrantMat + PrintfFormat.NEWLINE);
        for (int i = i1; i <= i2; ++i) {
            sb.append(OuvrantVec);
            for (int j = j1; j <= j2; ++j) {
                sb.append(' ');
                switch (style) {
                    case 1: {
                        String S;
                        double x = Mat[i][j];
                        if (x != 0.0 && Math.abs(x) < 0.1 || Math.abs(x) > prec) {
                            S = PrintfFormat.G(0, p, x);
                            int exppos = S.indexOf(69);
                            if (exppos != -1) {
                                S = S.substring(0, exppos) + "*10^(" + S.substring(exppos + 1) + ")";
                            }
                        } else {
                            S = PrintfFormat.f(0, p, x);
                        }
                        S = PrintfFormat.s(w, S);
                        break;
                    }
                    default: {
                        sb.append(PrintfFormat.G(w, p, Mat[i][j]));
                    }
                }
                if (j >= j2) continue;
                sb.append(SepareElem);
            }
            sb.append(FermantVec);
            if (i >= i2) continue;
            sb.append(SepareVec + PrintfFormat.NEWLINE);
        }
        sb.append(FermantMat + PrintfFormat.NEWLINE);
        return sb.toString();
    }

    public static String format(int[][] Mat, int i1, int i2, int j1, int j2, int w, int style, String Name) {
        TableFormat.fixeDelim(style);
        StringBuffer sb = new StringBuffer();
        if (Name.length() > 0) {
            sb.append(Name + " = ");
        }
        sb.append(OuvrantMat + PrintfFormat.NEWLINE);
        for (int i = i1; i <= i2; ++i) {
            sb.append(OuvrantVec);
            for (int j = j1; j <= j2; ++j) {
                sb.append(PrintfFormat.d(w, Mat[i][j]));
                if (j >= j2) continue;
                sb.append(SepareElem);
            }
            sb.append(FermantVec);
            if (i >= i2) continue;
            sb.append(SepareVec + PrintfFormat.NEWLINE);
        }
        sb.append(FermantMat + PrintfFormat.NEWLINE + PrintfFormat.NEWLINE);
        return sb.toString();
    }
}

