/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.util;

public abstract class AbstractChrono {
    private long m_second;
    private long m_microsec;
    private long[] now = new long[2];

    protected abstract void getTime(long[] var1);

    public void init() {
        this.getTime(this.now);
        this.m_second = this.now[0];
        this.m_microsec = this.now[1];
    }

    public double getSeconds() {
        this.getTime(this.now);
        double time = (double)(this.now[1] - this.m_microsec) / 1000000.0 + (double)(this.now[0] - this.m_second);
        return time;
    }

    public double getMinutes() {
        this.getTime(this.now);
        double time = (double)(this.now[1] - this.m_microsec) / 1000000.0 + (double)(this.now[0] - this.m_second);
        return time * 1.666666667 * 0.01;
    }

    public double getHours() {
        this.getTime(this.now);
        double time = (double)(this.now[1] - this.m_microsec) / 1000000.0 + (double)(this.now[0] - this.m_second);
        return time * 2.777777778 * 1.0E-4;
    }

    public String format() {
        return AbstractChrono.format(this.getSeconds());
    }

    public static String format(double time) {
        int min;
        int hour = (int)(time / 3600.0);
        if (hour > 0) {
            time -= (double)hour * 3600.0;
        }
        if ((min = (int)(time / 60.0)) > 0) {
            time -= (double)min * 60.0;
        }
        int second = (int)time;
        int centieme = (int)(100.0 * (time - (double)second) + 0.5);
        return String.valueOf(hour) + ":" + min + ":" + second + "." + centieme;
    }
}

