/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stat.density;

import umontreal.ssj.probdist.NormalDist;
import umontreal.ssj.stat.density.DensityDerivativeEstimator;

public class DEDerivativeGaussian
extends DensityDerivativeEstimator {
    public DEDerivativeGaussian(int order) {
        this.setOrder(order);
    }

    public DEDerivativeGaussian(int order, double[] data) {
        this(order);
        this.data = data;
    }

    public DEDerivativeGaussian(double h) {
        this.setH(h);
    }

    public DEDerivativeGaussian(double h, double[] data) {
        this(h);
        this.data = data;
    }

    public DEDerivativeGaussian(int order, double h) {
        this(order);
        this.setH(h);
    }

    public DEDerivativeGaussian(int order, double h, double[] data) {
        this(order, h);
        this.data = data;
    }

    @Override
    public double evalDensity(double x) {
        double sign = this.getOrder() % 2 == 0 ? 1.0 : -1.0;
        double density = 0.0;
        int n = this.data.length;
        double nInv = 1.0 / (double)n;
        double hInv = 1.0 / this.getH();
        double norma = sign * nInv * Math.pow(hInv, (double)this.getOrder() + 1.0);
        for (int i = 0; i < n; ++i) {
            double z = (x - this.data[i]) * hInv;
            density += NormalDist.density01(z) * DEDerivativeGaussian.hermitePoly(this.getOrder(), z);
        }
        return density *= norma;
    }

    @Override
    public double[] evalDensity(double[] evalPoints) {
        double z = 0.0;
        double sign = this.getOrder() % 2 == 0 ? 1.0 : -1.0;
        int k = evalPoints.length;
        double[] density = new double[k];
        int n = this.data.length;
        double nInv = 1.0 / (double)n;
        double hInv = 1.0 / this.getH();
        double norma = sign * nInv * Math.pow(hInv, (double)this.getOrder() + 1.0);
        for (int j = 0; j < k; ++j) {
            for (int i = 0; i < n; ++i) {
                z = (evalPoints[j] - this.data[i]) * hInv;
            }
            int n2 = k;
            density[n2] = density[n2] + NormalDist.density01(z) * DEDerivativeGaussian.hermitePoly(this.getOrder(), z);
            int n3 = k;
            density[n3] = density[n3] * norma;
        }
        return density;
    }

    @Override
    public String toString() {
        return "DDE [Gaussian kernel with h = " + this.getH() + "]";
    }

    public static double evalDensity(double x, int order, double h, double[] data) {
        double sign = order % 2 == 0 ? 1.0 : -1.0;
        double density = 0.0;
        int n = data.length;
        double nInv = 1.0 / (double)n;
        double hInv = 1.0 / h;
        double norma = sign * nInv * Math.pow(hInv, (double)order + 1.0);
        for (int i = 0; i < n; ++i) {
            double z = (x - data[i]) * hInv;
            density += NormalDist.density01(z) * DEDerivativeGaussian.hermitePoly(order, z);
        }
        return density *= norma;
    }

    public static double[] evalDensity(double[] evalPoints, int order, double h, double[] data) {
        double z = 0.0;
        double sign = order == 0 ? 1.0 : -1.0;
        int k = evalPoints.length;
        double[] density = new double[k];
        int n = data.length;
        double nInv = 1.0 / (double)n;
        double hInv = 1.0 / h;
        double norma = sign * nInv * Math.pow(hInv, (double)order + 1.0);
        for (int j = 0; j < k; ++j) {
            for (int i = 0; i < n; ++i) {
                z = (evalPoints[j] - data[i]) * hInv;
            }
            int n2 = k;
            density[n2] = density[n2] + NormalDist.density01(z) * DEDerivativeGaussian.hermitePoly(order, z);
            int n3 = k;
            density[n3] = density[n3] * norma;
        }
        return density;
    }

    public static double[][] evalDensity(double[] evalPoints, int order, double h, double[][] data) {
        int m = data.length;
        double[][] density = new double[m][];
        for (int r = 0; r < m; ++r) {
            density[r] = DEDerivativeGaussian.evalDensity(evalPoints, order, h, data[r]);
        }
        return density;
    }

    public static double hermitePoly(int r, double x) {
        if (r == 0) {
            return 1.0;
        }
        if (r == 1) {
            return x;
        }
        return DEDerivativeGaussian.hermitePoly(r - 1, x) * x - ((double)r - 1.0) * DEDerivativeGaussian.hermitePoly(r - 2, x);
    }
}

