/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvar;

import umontreal.ssj.probdist.BetaDist;
import umontreal.ssj.randvar.RandomVariateGen;
import umontreal.ssj.rng.RandomStream;

public class BetaGen
extends RandomVariateGen {
    protected double p;
    protected double q;
    protected double a;
    protected double b;
    protected int gen;

    public BetaGen(RandomStream s, double alpha, double beta, double a, double b) {
        super(s, new BetaDist(alpha, beta, a, b));
        this.setParams(alpha, beta, a, b);
    }

    public BetaGen(RandomStream s, double alpha, double beta) {
        this(s, alpha, beta, 0.0, 1.0);
    }

    public BetaGen(RandomStream s, BetaDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getAlpha(), dist.getBeta(), dist.getA(), dist.getB());
        }
    }

    public static double nextDouble(RandomStream s, double alpha, double beta, double a, double b) {
        return BetaDist.inverseF(alpha, beta, a, b, 15, s.nextDouble());
    }

    public double getAlpha() {
        return this.p;
    }

    public double getBeta() {
        return this.q;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    protected void setParams(double alpha, double beta, double aa, double bb) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (aa >= bb) {
            throw new IllegalArgumentException("a >= b");
        }
        this.p = alpha;
        this.q = beta;
        this.a = aa;
        this.b = bb;
    }
}

