/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.probdist;

import umontreal.ssj.probdist.LognormalDist;

public class LognormalDistFromMoments
extends LognormalDist {
    public LognormalDistFromMoments(double mean, double var) {
        super(LognormalDistFromMoments.getMu(mean, var), Math.sqrt(LognormalDistFromMoments.getSigma2(mean, var)));
    }

    private static double getMu(double mean, double var) {
        double sigma2 = LognormalDistFromMoments.getSigma2(mean, var);
        return Math.log(mean) - sigma2 / 2.0;
    }

    private static double getSigma2(double mean, double var) {
        if (mean <= 0.0) {
            throw new IllegalArgumentException("Mean must be positive");
        }
        if (var <= 0.0) {
            throw new IllegalArgumentException("Variance must be positive");
        }
        return Math.log(var / (mean * mean) + 1.0);
    }
}

