/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.mcqmctools.anova;

import umontreal.ssj.hups.PointSetIterator;
import umontreal.ssj.mcqmctools.MonteCarloModel;
import umontreal.ssj.mcqmctools.MonteCarloModelDouble;
import umontreal.ssj.mcqmctools.anova.ObservationCollector;
import umontreal.ssj.mcqmctools.anova.RandomSampler;
import umontreal.ssj.rng.RandomStream;
import umontreal.ssj.stat.Tally;

public class MonteCarloSampler
implements RandomSampler {
    protected int nSamples;
    protected RandomStream stream;

    public MonteCarloSampler(int nSamples) {
        this.nSamples = nSamples;
    }

    public MonteCarloSampler(int nSamples, RandomStream stream) {
        this.nSamples = nSamples;
        this.stream = stream;
    }

    @Override
    public RandomStream getStream() {
        return this.stream;
    }

    @Override
    public int getNumSimulationsPerSample() {
        return 1;
    }

    @Override
    public int getNumSamples() {
        return this.nSamples;
    }

    public void setNumSamples(int nSamples) {
        this.nSamples = nSamples;
    }

    @Override
    public void setStream(RandomStream stream) {
        this.stream = stream;
    }

    @Override
    public <E> void simulateRuns(MonteCarloModel<? extends E> model, ObservationCollector<E> collector) {
        PointSetIterator psit = null;
        if (this.stream instanceof PointSetIterator) {
            psit = (PointSetIterator)this.stream;
        }
        for (int i = 0; i < this.nSamples; ++i) {
            model.simulate(this.stream);
            collector.observe(model.getPerformance());
            if (psit == null) continue;
            psit.resetToNextPoint();
        }
    }

    @Override
    public void simulateRuns(MonteCarloModelDouble model, Tally collector) {
        boolean isPointSet = this.stream instanceof PointSetIterator;
        for (int i = 0; i < this.nSamples; ++i) {
            model.simulate(this.stream);
            collector.add(model.getPerformance());
            if (!isPointSet) continue;
            ((PointSetIterator)this.stream).resetToNextPoint();
        }
    }

    public String toString() {
        String s = "Monte Carlo Sampler [samples=" + this.getNumSamples() + "]";
        if (this.getStream() != null) {
            s = s + " [stream=" + this.getStream().getClass().getSimpleName() + "]";
        }
        return s;
    }
}

