/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.mcqmctools;

import umontreal.ssj.mcqmctools.MonteCarloModelCV;
import umontreal.ssj.mcqmctools.MonteCarloModelDouble;
import umontreal.ssj.mcqmctools.MonteCarloModelDoubleArray;
import umontreal.ssj.rng.RandomStream;
import umontreal.ssj.stat.Tally;
import umontreal.ssj.stat.TallyStore;
import umontreal.ssj.stat.list.ListOfTallies;
import umontreal.ssj.stat.list.lincv.ListOfTalliesWithCV;
import umontreal.ssj.util.Chrono;
import umontreal.ssj.util.PrintfFormat;

public class MonteCarloExperiment {
    public static void simulateRuns(MonteCarloModelDouble model, int n, RandomStream stream, Tally statValue) {
        statValue.init();
        for (int i = 0; i < n; ++i) {
            model.simulate(stream);
            statValue.add(model.getPerformance());
            stream.resetNextSubstream();
        }
    }

    public static void simulateRuns(MonteCarloModelDoubleArray model, int n, RandomStream stream, ListOfTallies<? extends Tally> statValueList) {
        statValueList.init();
        for (int i = 0; i < n; ++i) {
            model.simulate(stream);
            statValueList.add(model.getPerformance());
            stream.resetNextSubstream();
        }
    }

    public static void simulateRunsCV(MonteCarloModelCV model, int n, RandomStream stream, ListOfTalliesWithCV<Tally> statWithCV) {
        statWithCV.init();
        for (int i = 0; i < n; ++i) {
            model.simulate(stream);
            statWithCV.add(model.getPerformance(), model.getValuesCV());
            stream.resetNextSubstream();
        }
    }

    public static void simulateRunsCV(MonteCarloModelCV model, int n, RandomStream stream, TallyStore statX, TallyStore statC) {
        statX.init();
        statC.init();
        for (int i = 0; i < n; ++i) {
            model.simulate(stream);
            statX.add(model.getPerformance());
            statC.add(model.getValuesCV()[0]);
            stream.resetNextSubstream();
        }
    }

    public static void simulateRunsCV(MonteCarloModelCV model, int n, RandomStream stream, double[] mean, double[] variance) {
        TallyStore statX = new TallyStore(n);
        TallyStore statC = new TallyStore(n);
        MonteCarloExperiment.simulateRunsCV(model, n, stream, statX, statC);
        MonteCarloExperiment.computeMeanVarCV(statX, statC, mean, variance);
    }

    public static void computeMeanVarCV(TallyStore statX, TallyStore statC, double[] mean, double[] variance) {
        mean[0] = statX.average();
        variance[0] = statX.variance();
        double meanC = statC.average();
        double varC = statC.variance();
        double covCX = statC.covariance(statX);
        double beta = covCX / varC;
        mean[1] = mean[0] - beta * meanC;
        variance[1] = variance[0] + beta * beta * varC - 2.0 * beta * covCX;
    }

    public static void simulFDReplicatesCRN(MonteCarloModelDouble model1, MonteCarloModelDouble model2, double delta, int n, RandomStream stream, Tally statDiff) {
        statDiff.init();
        for (int i = 0; i < n; ++i) {
            stream.resetNextSubstream();
            model1.simulate(stream);
            double value1 = model1.getPerformance();
            stream.resetStartSubstream();
            model2.simulate(stream);
            statDiff.add((model2.getPerformance() - value1) / delta);
        }
    }

    public static void simulFDReplicatesIRN(MonteCarloModelDouble model1, MonteCarloModelDouble model2, double delta, int n, RandomStream stream, Tally statDiff) {
        statDiff.init();
        for (int i = 0; i < n; ++i) {
            stream.resetNextSubstream();
            model1.simulate(stream);
            double value1 = model1.getPerformance();
            model2.simulate(stream);
            statDiff.add((model2.getPerformance() - value1) / delta);
        }
    }

    public static String simulateRunsDefaultReportStudent(MonteCarloModelDouble model, int n, RandomStream stream, Tally statValue, double level, int d, Chrono timer) {
        PrintfFormat str = new PrintfFormat();
        timer.init();
        MonteCarloExperiment.simulateRuns(model, n, stream, statValue);
        statValue.setConfidenceIntervalStudent();
        str.append(model.toString() + "\n");
        str.append(statValue.report(level, d));
        str.append("\n");
        str.append("Total CPU time:      " + timer.format() + "\n");
        return str.toString();
    }

    public static String simulateRunsDefaultReportStudent(MonteCarloModelDouble model, int n, RandomStream stream, Tally statValue, double level, int d) {
        Chrono timer = new Chrono();
        return MonteCarloExperiment.simulateRunsDefaultReportStudent(model, n, stream, statValue, level, d, timer);
    }

    public static String simulateRunsDefaultReport(MonteCarloModelDouble model, int n, RandomStream stream, Tally statValue) {
        Chrono timer = new Chrono();
        return MonteCarloExperiment.simulateRunsDefaultReportStudent(model, n, stream, statValue, 0.95, 4, timer);
    }

    public static String simulateRunsDefaultReportCV(MonteCarloModelCV model, int n, RandomStream stream, ListOfTalliesWithCV<Tally> statWithCV, double level, int d, Chrono timer) {
        PrintfFormat str = new PrintfFormat();
        timer.init();
        MonteCarloExperiment.simulateRunsCV(model, n, stream, statWithCV);
        statWithCV.estimateBeta();
        str.append(model.toString() + "\n");
        double[] centerAndRadius = new double[2];
        statWithCV.confidenceIntervalStudentWithCV(0, level, centerAndRadius);
        str.append("Average: " + statWithCV.averageWithCV(0) + "\n");
        str.append("Variance per run, no CV: " + statWithCV.covarianceWithCV(0, 0) + "\n");
        double[] varCV = new double[1];
        statWithCV.varianceWithCV(varCV);
        str.append("Variance per run with CV: " + varCV[0] + "\n");
        str.append("Center of CI:  " + centerAndRadius[0] + "\n");
        str.append("Radius of CI:  " + centerAndRadius[1] + "\n");
        str.append("Total CPU time:     " + timer.format() + "\n");
        return str.toString();
    }

    public static String simulateRunsDefaultReportCV(MonteCarloModelCV model, int n, RandomStream stream, double[] mean, double[] variance, double level, int d, Chrono timer) {
        PrintfFormat str = new PrintfFormat();
        timer.init();
        MonteCarloExperiment.simulateRunsCV(model, n, stream, mean, variance);
        str.append(model.toString() + "\n");
        str.append("Average, no CV:  " + mean[0] + "\n");
        str.append("Average with CV:  " + mean[1] + "\n");
        str.append("Variance, no CV:  " + variance[0] + "\n");
        str.append("Variance with CV:  " + variance[1] + "\n");
        str.append("Total CPU time:      " + timer.format() + "\n");
        return str.toString();
    }
}

