/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.hups;

import umontreal.ssj.hups.PointSet;
import umontreal.ssj.hups.PointSetIterator;
import umontreal.ssj.hups.PointSetRandomization;
import umontreal.ssj.rng.RandomStream;
import umontreal.ssj.util.PrintfFormat;

public abstract class ContainerPointSet
extends PointSet {
    protected PointSet P;

    protected void init(PointSet p0) {
        this.P = p0;
    }

    public PointSet getOriginalPointSet() {
        return this.P;
    }

    @Override
    public int getDimension() {
        return this.P.getDimension();
    }

    @Override
    public int getNumPoints() {
        return this.P.getNumPoints();
    }

    @Override
    public double getCoordinate(int i, int j) {
        return this.P.getCoordinate(i, j);
    }

    @Override
    public PointSetIterator iterator() {
        return new ContainerPointSetIterator();
    }

    @Override
    public void randomize(PointSetRandomization rand) {
        this.P.randomize(rand);
    }

    @Override
    public void addRandomShift(int d1, int d2, RandomStream stream) {
        this.P.addRandomShift(d1, d2, stream);
    }

    @Override
    public void addRandomShift(RandomStream stream) {
        this.P.addRandomShift(stream);
    }

    @Override
    public void clearRandomShift() {
        this.P.clearRandomShift();
    }

    @Override
    public String toString() {
        return "Container point set of: {" + PrintfFormat.NEWLINE + this.P.toString() + PrintfFormat.NEWLINE + "}";
    }

    protected class ContainerPointSetIterator
    extends PointSet.DefaultPointSetIterator {
        protected PointSetIterator innerIterator;

        protected ContainerPointSetIterator() {
            super(ContainerPointSet.this);
            this.innerIterator = ContainerPointSet.this.P.iterator();
        }

        @Override
        public void setCurCoordIndex(int j) {
            this.innerIterator.setCurCoordIndex(j);
        }

        @Override
        public void resetCurCoordIndex() {
            this.innerIterator.resetCurCoordIndex();
        }

        @Override
        public boolean hasNextCoordinate() {
            return this.innerIterator.hasNextCoordinate();
        }

        @Override
        public double nextCoordinate() {
            return this.innerIterator.nextCoordinate();
        }

        @Override
        public void setCurPointIndex(int i) {
            this.innerIterator.setCurPointIndex(i);
        }

        @Override
        public void resetCurPointIndex() {
            this.innerIterator.resetCurPointIndex();
        }

        @Override
        public int resetToNextPoint() {
            return this.innerIterator.resetToNextPoint();
        }

        @Override
        public boolean hasNextPoint() {
            return this.innerIterator.hasNextPoint();
        }
    }
}

