/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.functions;

import umontreal.ssj.functions.MathFunction;
import umontreal.ssj.functions.MathFunctionUtil;
import umontreal.ssj.functions.MathFunctionWithDerivative;
import umontreal.ssj.functions.MathFunctionWithFirstDerivative;
import umontreal.ssj.functions.MathFunctionWithIntegral;

public class AverageMathFunction
implements MathFunction,
MathFunctionWithFirstDerivative,
MathFunctionWithDerivative,
MathFunctionWithIntegral {
    private MathFunction[] func;

    public AverageMathFunction(MathFunction ... func) {
        if (func == null) {
            throw new NullPointerException();
        }
        this.func = (MathFunction[])func.clone();
    }

    public MathFunction[] getFunctions() {
        return (MathFunction[])this.func.clone();
    }

    @Override
    public double evaluate(double x) {
        double sum = 0.0;
        for (MathFunction fi : this.func) {
            sum += fi.evaluate(x);
        }
        return sum / (double)this.func.length;
    }

    @Override
    public double derivative(double x, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n must be greater than or equal to 0");
        }
        if (n == 0) {
            return this.evaluate(x);
        }
        double sum = 0.0;
        for (MathFunction fi : this.func) {
            sum += MathFunctionUtil.derivative(fi, x, n);
        }
        return sum / (double)this.func.length;
    }

    @Override
    public double derivative(double x) {
        double sum = 0.0;
        for (MathFunction fi : this.func) {
            sum += MathFunctionUtil.derivative(fi, x);
        }
        return sum / (double)this.func.length;
    }

    @Override
    public double integral(double a, double b) {
        double sum = 0.0;
        for (MathFunction fi : this.func) {
            sum += MathFunctionUtil.integral(fi, a, b);
        }
        return sum / (double)this.func.length;
    }
}

