/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.discrepancy;

import umontreal.ssj.discrepancy.Discrepancy;
import umontreal.ssj.discrepancy.Searcher;
import umontreal.ssj.hups.KorobovLattice;
import umontreal.ssj.util.Num;

public class SearcherKorobov
extends Searcher {
    protected int bestA;

    protected void print(int y) {
        System.out.printf("  a = %d%n", y);
    }

    private void calcAs(int n, int s, int a) {
        long b = a;
        this.bestAs[0] = 1;
        for (int j = 1; j < s; ++j) {
            this.bestAs[j] = (int)(b * (long)this.bestAs[j - 1] % (long)n);
        }
    }

    private double exhaust(int s, boolean relPrime) {
        int n = this.disc.getNumPoints();
        this.gamma = this.disc.getGamma();
        this.bestVal = Double.MAX_VALUE;
        this.bestA = -1;
        for (int i = 2; i < n; ++i) {
            if (relPrime && (this.power2F ? (i & 1) == 0 : Num.gcd(n, i) != 1)) continue;
            this.lat = new KorobovLattice(n, i, s);
            double err = this.disc.compute(this.lat, this.gamma);
            if (!(err < this.bestVal)) continue;
            this.bestVal = err;
            this.bestA = i;
        }
        this.calcAs(n, s, this.bestA);
        return this.bestVal;
    }

    private double random(int s, int k, boolean relPrime) {
        int n = this.disc.getNumPoints();
        if (k >= n) {
            return this.exhaust(s, relPrime);
        }
        this.gamma = this.disc.getGamma();
        int nm1 = n - 1;
        this.bestVal = Double.MAX_VALUE;
        this.bestA = -1;
        for (int i = 0; i < k; ++i) {
            int a;
            if (this.power2F) {
                a = gen.nextInt(2, nm1);
                if (relPrime) {
                    a |= 1;
                }
            } else {
                do {
                    a = gen.nextInt(2, nm1);
                } while (relPrime && Num.gcd(n, a) != 1);
            }
            this.lat = new KorobovLattice(n, a, s);
            double err = this.disc.compute(this.lat, this.gamma);
            if (!(err < this.bestVal)) continue;
            this.bestVal = err;
            this.bestA = a;
        }
        this.calcAs(n, s, this.bestA);
        return this.bestVal;
    }

    public SearcherKorobov(Discrepancy disc, boolean primeN) {
        super(disc, primeN);
    }

    @Override
    public double exhaust(int s) {
        return this.exhaust(s, false);
    }

    @Override
    public double exhaustPrime(int s) {
        if (this.primeN) {
            return this.exhaust(s, false);
        }
        return this.exhaust(s, true);
    }

    @Override
    public double random(int s, int k) {
        return this.random(s, k, false);
    }

    @Override
    public double randomPrime(int s, int k) {
        if (this.primeN) {
            return this.random(s, k, false);
        }
        return this.random(s, k, true);
    }

    public int getBestA() {
        return this.bestA;
    }
}

