/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.discrepancy;

import umontreal.ssj.discrepancy.Discrepancy;
import umontreal.ssj.hups.PointSet;

public class DiscShift1
extends Discrepancy {
    protected static void setC(double[] C1, double[] gam, int s) {
        for (int i = 0; i < s; ++i) {
            C1[i] = gam[i] * gam[i];
        }
    }

    public DiscShift1(double[][] points, int n, int s) {
        super(points, n, s);
    }

    public DiscShift1(double[][] points, int n, int s, double[] gamma) {
        super(points, n, s, gamma);
    }

    public DiscShift1(int n, int s, double[] gamma) {
        super(n, s, gamma);
    }

    public DiscShift1(PointSet set) {
        super(set);
    }

    public DiscShift1() {
    }

    @Override
    public double compute(double[][] points, int n, int s) {
        DiscShift1.setONES(s);
        return this.compute(points, n, s, ONES);
    }

    @Override
    public double compute(double[][] points, int n, int s, double[] gamma) {
        double[] C1 = new double[s];
        DiscShift1.setC(C1, gamma, s);
        double pol1 = 0.16666666666666666;
        double prod = 1.0;
        for (int r = 0; r < s; ++r) {
            prod *= 1.0 + C1[r] * pol1;
        }
        double disc = prod / (double)n;
        double sum = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                prod = 1.0;
                for (int r = 0; r < s; ++r) {
                    double u = points[i][r] - points[j][r];
                    if (u < 0.0) {
                        u += 1.0;
                    }
                    pol1 = u * (u - 1.0) + 0.16666666666666666;
                    prod *= 1.0 + C1[r] * pol1;
                }
                sum += prod;
            }
        }
        if ((disc += 2.0 * sum / (double)((long)n * (long)n) - 1.0) < 0.0) {
            return -1.0;
        }
        return Math.sqrt(disc);
    }

    @Override
    public double compute(double[] T, int n) {
        double pol1 = 0.16666666666666666;
        double disc = pol1 / (double)n;
        double sum = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                double h = T[i] - T[j];
                if (h < 0.0) {
                    h += 1.0;
                }
                pol1 = h * (h - 1.0) + 0.16666666666666666;
                sum += pol1;
            }
        }
        if ((disc += 2.0 * sum / (double)((long)n * (long)n)) < 0.0) {
            return -1.0;
        }
        return Math.sqrt(disc);
    }
}

