/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.util.sort;

import java.util.Arrays;
import umontreal.ssj.util.sort.DoubleArrayComparator;
import umontreal.ssj.util.sort.MultiDimComparable;
import umontreal.ssj.util.sort.MultiDimComparator;
import umontreal.ssj.util.sort.MultiDimSortComparable;

public class BatchSort<T extends MultiDimComparable<? super T>>
implements MultiDimSortComparable<T> {
    int dimension;
    boolean useExponents;
    int[] batchNumbers;
    double[] batchExponents;
    int batchProduct = 1;
    int nSaved = 0;

    public BatchSort(int[] batchNumbers) {
        if (batchNumbers == null) {
            throw new NullPointerException("batchNumbers is null");
        }
        this.useExponents = false;
        this.batchNumbers = batchNumbers;
        this.dimension = batchNumbers.length;
        this.batchProduct = 1;
        for (int i = 0; i < batchNumbers.length; ++i) {
            this.batchProduct *= batchNumbers[i];
        }
    }

    public BatchSort(double[] batchExponents) {
        if (batchExponents == null) {
            throw new NullPointerException("batchExponents is null");
        }
        this.batchExponents = batchExponents;
        this.useExponents = true;
        this.dimension = batchExponents.length;
        this.batchNumbers = new int[this.dimension];
        double sum = 0.0;
        for (int j = 0; j < this.dimension; ++j) {
            sum += batchExponents[j];
        }
        if (Math.abs(sum - 1.0) > 1.0E-10) {
            throw new IllegalArgumentException("Sum of batchExponents not equal to 1");
        }
    }

    public void setBatchNumbers(int n) {
        if (this.batchExponents == null) {
            throw new NullPointerException("batchExponents is null");
        }
        if (!this.useExponents) {
            throw new IllegalArgumentException("method allowed only when using proportion exponents");
        }
        this.nSaved = n;
        this.batchProduct = 1;
        for (int dim = 0; dim < this.dimension; ++dim) {
            this.batchNumbers[dim] = (int)Math.ceil(Math.pow(n, this.batchExponents[dim]));
            this.batchProduct *= this.batchNumbers[dim];
        }
    }

    public void setBatchExponents(double[] batchExponents) {
        if (batchExponents == null) {
            throw new NullPointerException("batchExponents is null");
        }
        if (batchExponents.length != this.dimension) {
            throw new IllegalArgumentException("batchExponents has wrong dimension");
        }
        this.nSaved = 0;
        this.useExponents = true;
        this.batchExponents = batchExponents;
        double sumExponents = 0.0;
        for (int dim = 0; dim < this.dimension; ++dim) {
            sumExponents += batchExponents[dim];
        }
        if (Math.abs(sumExponents - 1.0) > 1.0E-10) {
            throw new IllegalArgumentException("Sum of batchExponents not equal to 1");
        }
    }

    public int[] getBatchNumbers() {
        return this.batchNumbers;
    }

    public int getBatchProduct() {
        return this.batchProduct;
    }

    public double[] getBatchExponents() {
        return this.batchExponents;
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    @Override
    public void sort(T[] a, int iMin, int iMax) {
        if (iMin + 1 == iMax) {
            return;
        }
        if (this.useExponents && this.nSaved != iMax - iMin) {
            this.setBatchNumbers(iMax - iMin);
        }
        int bsize = iMax - iMin;
        for (int j = 0; j < this.dimension && bsize > 1; ++j) {
            MultiDimComparator compar = new MultiDimComparator(j);
            if (this.batchNumbers[j] == 1) continue;
            for (int i1 = iMin; i1 < iMax; i1 += bsize) {
                int i2 = i1 + bsize;
                if (i2 > iMax) {
                    i2 = iMax;
                }
                Arrays.sort(a, i1, i2, compar);
            }
            bsize = (int)Math.ceil(bsize / this.batchNumbers[j]);
        }
    }

    @Override
    public void sort(T[] a) {
        this.sort((MultiDimComparable[])a, 0, a.length);
    }

    @Override
    public void sort(double[][] a, int iMin, int iMax) {
        if (iMin + 1 == iMax) {
            return;
        }
        if (this.useExponents && this.nSaved != iMax - iMin) {
            this.setBatchNumbers(iMax - iMin);
        }
        int bsize = iMax - iMin;
        for (int j = 0; j < this.dimension && bsize > 1; ++j) {
            DoubleArrayComparator compar = new DoubleArrayComparator(j);
            if (this.batchNumbers[j] == 1) continue;
            for (int i1 = iMin; i1 < iMax; i1 += bsize) {
                int i2 = i1 + bsize;
                if (i2 > iMax) {
                    i2 = iMax;
                }
                Arrays.sort(a, i1, i2, compar);
            }
            bsize = (int)Math.ceil(bsize / this.batchNumbers[j]);
        }
    }

    @Override
    public void sort(double[][] a) {
        this.sort(a, 0, a.length);
    }
}

