/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stochprocess;

import umontreal.ssj.probdist.NormalDistQuick;
import umontreal.ssj.randvar.NormalGen;
import umontreal.ssj.rng.RandomStream;
import umontreal.ssj.stochprocess.InverseGaussianProcess;
import umontreal.ssj.stochprocess.InverseGaussianProcessBridge;
import umontreal.ssj.stochprocess.InverseGaussianProcessMSH;
import umontreal.ssj.stochprocess.InverseGaussianProcessPCA;
import umontreal.ssj.stochprocess.StochasticProcess;

public class NormalInverseGaussianProcess
extends StochasticProcess {
    protected RandomStream streamIG1;
    protected RandomStream streamIG2;
    protected RandomStream streamBrownian;
    protected InverseGaussianProcess igProcess;
    protected NormalGen normalGen;
    protected double[] stochTime;
    double[] dt;
    double[] mudt;
    protected double mu;
    protected double delta;
    protected double alpha;
    protected double beta;
    protected double gamma;

    public NormalInverseGaussianProcess(double x0, double alpha, double beta, double mu, double delta, RandomStream streamBrownian, InverseGaussianProcess igP) {
        this.setParams(x0, alpha, beta, mu, delta);
        this.streamBrownian = streamBrownian;
        this.normalGen = new NormalGen(streamBrownian);
        this.igProcess = igP;
        this.streamIG2 = this.streamIG1 = this.igProcess.getStream();
    }

    public NormalInverseGaussianProcess(double x0, double alpha, double beta, double mu, double delta, RandomStream streamBrownian, RandomStream streamIG1, RandomStream streamIG2, String igType) {
        this.setParams(x0, alpha, beta, mu, delta);
        this.streamIG1 = streamIG1;
        this.streamIG2 = streamIG2;
        this.streamBrownian = streamBrownian;
        this.normalGen = new NormalGen(streamBrownian);
        if (igType.compareTo("SEQUENTIAL_SLOW") == 0) {
            this.igProcess = new InverseGaussianProcess(0.0, delta, this.gamma, streamIG1);
        } else if (igType.compareTo("SEQUENTIAL_MSH") == 0) {
            this.igProcess = new InverseGaussianProcessMSH(0.0, delta, this.gamma, streamIG1, streamIG2);
        } else if (igType.compareTo("BRIDGE") == 0) {
            this.igProcess = new InverseGaussianProcessBridge(0.0, delta, this.gamma, streamIG1, streamIG2);
        } else if (igType.compareTo("PCA") == 0) {
            this.igProcess = new InverseGaussianProcessPCA(0.0, delta, this.gamma, streamIG1);
        } else {
            throw new IllegalArgumentException("Unrecognized igType");
        }
    }

    public NormalInverseGaussianProcess(double x0, double alpha, double beta, double mu, double delta, RandomStream streamAll, String igType) {
        this(x0, alpha, beta, mu, delta, streamAll, streamAll, streamAll, igType);
    }

    @Override
    public double[] generatePath() {
        int j;
        if (this.igProcess.getNumberOfRandomStreams() != 1) {
            return this.generatePathTwoIGStreams();
        }
        double x = this.x0;
        double[] randomNormal = new double[this.d];
        double[] randomIG1 = new double[this.d];
        for (j = 0; j < this.d; ++j) {
            randomIG1[j] = this.streamIG1.nextDouble();
            randomNormal[j] = this.streamBrownian.nextDouble();
        }
        this.stochTime = this.igProcess.generatePath(randomIG1);
        for (j = 0; j < this.d; ++j) {
            double dy = this.stochTime[j + 1] - this.stochTime[j];
            this.path[j + 1] = x += this.mudt[j] + this.beta * dy + Math.sqrt(dy) * NormalDistQuick.inverseF01(randomNormal[j]);
        }
        this.observationIndex = this.d;
        return this.path;
    }

    protected double[] generatePathTwoIGStreams() {
        int j;
        double x = this.x0;
        double[] uniformNormal = new double[this.d];
        double[] uniformIG1 = new double[this.d];
        double[] uniformIG2 = new double[this.d];
        for (j = 0; j < this.d; ++j) {
            uniformIG1[j] = this.streamIG1.nextDouble();
            uniformNormal[j] = this.streamBrownian.nextDouble();
            uniformIG2[j] = this.streamIG2.nextDouble();
        }
        this.stochTime = this.igProcess.generatePath(uniformIG1, uniformIG2);
        for (j = 0; j < this.d; ++j) {
            double dy = this.stochTime[j + 1] - this.stochTime[j];
            this.path[j + 1] = x += this.mudt[j] + this.beta * dy + Math.sqrt(dy) * NormalDistQuick.inverseF01(uniformNormal[j]);
        }
        this.observationIndex = this.d;
        return this.path;
    }

    @Override
    public double nextObservation() {
        double igNext = this.igProcess.nextObservation();
        this.observationIndex = this.igProcess.getCurrentObservationIndex();
        this.stochTime[this.observationIndex] = igNext;
        double dY = igNext - this.stochTime[0];
        double dT = this.t[this.observationIndex] - this.t[0];
        this.path[this.observationIndex] = this.x0 + this.mu * dT + this.beta * dY + Math.sqrt(dY) * this.normalGen.nextDouble();
        return this.path[this.observationIndex];
    }

    @Override
    protected void init() {
        super.init();
        this.igProcess.setParams(this.delta, this.gamma);
        if (this.observationTimesSet) {
            this.stochTime = new double[this.d + 1];
            this.stochTime[0] = this.t[0];
            this.dt = new double[this.d];
            this.mudt = new double[this.d];
            for (int i = 0; i < this.d; ++i) {
                this.dt[i] = this.t[i + 1] - this.t[i];
                this.mudt[i] = this.dt[i] * this.mu;
            }
        }
    }

    @Override
    public void setObservationTimes(double[] t, int d) {
        super.setObservationTimes(t, d);
        this.igProcess.setObservationTimes(t, d);
        this.igProcess.x0 = t[0];
    }

    public void setParams(double x0, double alpha, double beta, double mu, double delta) {
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (Math.abs(beta) >= alpha) {
            throw new IllegalArgumentException("|beta| >= alpha");
        }
        this.x0 = x0;
        this.mu = mu;
        this.delta = delta;
        this.beta = beta;
        this.alpha = alpha;
        this.gamma = Math.sqrt(alpha * alpha - beta * beta);
        if (this.observationTimesSet) {
            this.init();
        }
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public double getMu() {
        return this.mu;
    }

    public double getDelta() {
        return this.delta;
    }

    public double getGamma() {
        return this.gamma;
    }

    public double getAnalyticAverage(double time) {
        return this.mu * time + this.delta * time * this.beta / this.gamma;
    }

    public double getAnalyticVariance(double time) {
        return this.delta * time * this.alpha * this.alpha / this.gamma / this.gamma / this.gamma;
    }

    @Override
    public RandomStream getStream() {
        if (this.streamIG1 != this.streamIG2 || this.streamIG1 != this.streamBrownian || this.streamIG1 != this.normalGen.getStream() || this.streamIG1 != this.igProcess.getStream()) {
            throw new UnsupportedOperationException("Two different streams or more are present");
        }
        return this.streamIG1;
    }

    @Override
    public void setStream(RandomStream stream) {
        this.streamIG2 = this.streamBrownian = stream;
        this.streamIG1 = this.streamBrownian;
        this.normalGen.setStream(stream);
        this.igProcess.setStream(stream);
    }
}

