/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvar;

import umontreal.ssj.probdist.NormalDist;
import umontreal.ssj.randvar.NormalGen;
import umontreal.ssj.rng.RandomStream;

public class NormalPolarGen
extends NormalGen {
    private boolean available = false;
    private double[] variates = new double[2];
    private static double[] staticVariates = new double[2];

    public NormalPolarGen(RandomStream s, double mu, double sigma) {
        super(s, null);
        this.setParams(mu, sigma);
    }

    public NormalPolarGen(RandomStream s) {
        this(s, 0.0, 1.0);
    }

    public NormalPolarGen(RandomStream s, NormalDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getMu(), dist.getSigma());
        }
    }

    @Override
    public double nextDouble() {
        if (this.available) {
            this.available = false;
            return this.mu + this.sigma * this.variates[1];
        }
        NormalPolarGen.polar(this.stream, this.mu, this.sigma, this.variates);
        this.available = true;
        return this.mu + this.sigma * this.variates[0];
    }

    public static double nextDouble(RandomStream s, double mu, double sigma) {
        NormalPolarGen.polar(s, mu, sigma, staticVariates);
        return mu + sigma * staticVariates[0];
    }

    private static void polar(RandomStream stream, double mu, double sigma, double[] variates) {
        double y;
        double x;
        double s;
        while ((s = (x = 2.0 * stream.nextDouble() - 1.0) * x + (y = 2.0 * stream.nextDouble() - 1.0) * y) > 1.0 || s == 0.0) {
        }
        double temp = Math.sqrt(-2.0 * Math.log(s) / s);
        variates[0] = y * temp;
        variates[1] = x * temp;
    }
}

