/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvar;

import umontreal.ssj.probdist.NakagamiDist;
import umontreal.ssj.randvar.RandomVariateGen;
import umontreal.ssj.rng.RandomStream;

public class NakagamiGen
extends RandomVariateGen {
    protected double a;
    protected double lambda;
    protected double c;

    public NakagamiGen(RandomStream s, double a, double lambda, double c) {
        super(s, new NakagamiDist(a, lambda, c));
        this.setParams(a, lambda, c);
    }

    public NakagamiGen(RandomStream s, NakagamiDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getA(), dist.getLambda(), dist.getC());
        }
    }

    public static double nextDouble(RandomStream s, double a, double lambda, double c) {
        return NakagamiDist.inverseF(a, lambda, c, s.nextDouble());
    }

    public double getA() {
        return this.a;
    }

    public double getLambda() {
        return this.lambda;
    }

    public double getC() {
        return this.c;
    }

    protected void setParams(double a, double lambda, double c) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (c <= 0.0) {
            throw new IllegalArgumentException("c <= 0");
        }
        this.a = a;
        this.lambda = lambda;
        this.c = c;
    }
}

