/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.hups;

import java.util.NoSuchElementException;
import umontreal.ssj.hups.PointSetIterator;
import umontreal.ssj.hups.PointSetRandomization;
import umontreal.ssj.rng.RandomStream;
import umontreal.ssj.util.Num;
import umontreal.ssj.util.PrintfFormat;

public abstract class PointSet {
    protected static final int MAXBITS = 31;
    protected double EpsilonHalf = 1.0 / Num.TWOEXP[55];
    protected int dim = 0;
    protected int numPoints = 0;
    protected int dimShift = 0;
    protected int capacityShift = 0;
    protected RandomStream shiftStream;

    public int getDimension() {
        return this.dim;
    }

    public int getNumPoints() {
        return this.numPoints;
    }

    public abstract double getCoordinate(int var1, int var2);

    public PointSetIterator iterator() {
        return new DefaultPointSetIterator();
    }

    public void setStream(RandomStream stream) {
        this.shiftStream = stream;
    }

    public RandomStream getStream() {
        return this.shiftStream;
    }

    public void randomize(PointSetRandomization rand) {
        rand.randomize(this);
    }

    @Deprecated
    public void addRandomShift(int d1, int d2, RandomStream stream) {
        System.out.println("******* WARNING:  addRandomShift in PointSet does nothing");
    }

    @Deprecated
    public void addRandomShift(RandomStream stream) {
        this.addRandomShift(0, this.dimShift, stream);
    }

    @Deprecated
    public void addRandomShift(int d1, int d2) {
        this.addRandomShift(d1, d2, this.shiftStream);
    }

    @Deprecated
    public void addRandomShift() {
        this.addRandomShift(0, this.dimShift, this.shiftStream);
    }

    @Deprecated
    public void clearRandomShift() {
        this.capacityShift = 0;
        this.dimShift = 0;
    }

    public void randomize(int fromDim, int toDim, RandomStream stream) {
        this.addRandomShift(fromDim, toDim, stream);
    }

    public void randomize(RandomStream stream) {
        this.addRandomShift(stream);
    }

    @Deprecated
    public void randomize(int d1, int d2) {
        this.addRandomShift(d1, d2);
    }

    @Deprecated
    public void randomize() {
        this.addRandomShift();
    }

    public void unrandomize() {
        this.clearRandomShift();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Number of points: ");
        int x = this.getNumPoints();
        if (x == Integer.MAX_VALUE) {
            sb.append("infinite");
        } else {
            sb.append(x);
        }
        sb.append(PrintfFormat.NEWLINE + "Point set dimension: ");
        x = this.getDimension();
        if (x == Integer.MAX_VALUE) {
            sb.append("infinite");
        } else {
            sb.append(x);
        }
        return sb.toString();
    }

    public String formatPoints() {
        PointSetIterator iter = this.iterator();
        return this.formatPoints(iter);
    }

    public String formatPoints(int n, int d) {
        PointSetIterator iter = this.iterator();
        return this.formatPoints(iter, n, d);
    }

    public String formatPoints(PointSetIterator iter) {
        int n = this.getNumPoints();
        if (n == Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Number of points is infinite");
        }
        int d = this.getDimension();
        if (d == Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Dimension is infinite");
        }
        return this.formatPoints(iter, n, d);
    }

    public String formatPoints(PointSetIterator iter, int n, int d) {
        if (this.getNumPoints() < n) {
            n = this.getNumPoints();
        }
        if (this.getDimension() < d) {
            d = this.getDimension();
        }
        StringBuffer sb = new StringBuffer(this.toString());
        sb.append(PrintfFormat.NEWLINE + PrintfFormat.NEWLINE + "Points of the point set:" + PrintfFormat.NEWLINE);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < d; ++j) {
                sb.append("  ");
                sb.append(iter.nextCoordinate());
            }
            sb.append(PrintfFormat.NEWLINE);
            iter.resetToNextPoint();
        }
        return sb.toString();
    }

    public String formatPointsBase(int b) {
        PointSetIterator iter = this.iterator();
        return this.formatPointsBase(iter, b);
    }

    public String formatPointsBase(int n, int d, int b) {
        PointSetIterator iter = this.iterator();
        return this.formatPointsBase(iter, n, d, b);
    }

    public String formatPointsBase(PointSetIterator iter, int b) {
        int n = this.getNumPoints();
        if (n == Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Number of points is infinite");
        }
        int d = this.getDimension();
        if (d == Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Dimension is infinite");
        }
        return this.formatPointsBase(iter, n, d, b);
    }

    public String formatPointsBase(PointSetIterator iter, int n, int d, int b) {
        if (this.getNumPoints() < n) {
            n = this.getNumPoints();
        }
        if (this.getDimension() < d) {
            d = this.getDimension();
        }
        StringBuffer sb = new StringBuffer(this.toString());
        sb.append(PrintfFormat.NEWLINE + PrintfFormat.NEWLINE + "Points of the point set:" + PrintfFormat.NEWLINE);
        int acc = 10;
        acc = b == 2 ? 20 : (b == 3 ? 13 : 10);
        if (null != this.shiftStream) {
            acc += 6;
        }
        int width = acc + 3;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < d; ++j) {
                sb.append("  ");
                double x = iter.nextCoordinate();
                String chaine = PrintfFormat.formatBase(-width, acc, b, x);
                sb.append(chaine);
            }
            sb.append(PrintfFormat.NEWLINE);
            iter.resetToNextPoint();
        }
        return sb.toString();
    }

    public String formatPointsNumbered() {
        int n = this.getNumPoints();
        if (n == Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Number of points is infinite");
        }
        int d = this.getDimension();
        if (d == Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Dimension is infinite");
        }
        return this.formatPointsNumbered(n, d);
    }

    public String formatPointsNumbered(int n, int d) {
        if (this.getNumPoints() < n) {
            n = this.getNumPoints();
        }
        if (this.getDimension() < d) {
            d = this.getDimension();
        }
        StringBuffer sb = new StringBuffer(this.toString());
        PointSetIterator itr = this.iterator();
        sb.append(PrintfFormat.NEWLINE + PrintfFormat.NEWLINE + "Points of the point set:");
        for (int i = 0; i < n; ++i) {
            sb.append(PrintfFormat.NEWLINE + "Point " + i + "  =  (");
            boolean first = true;
            for (int j = 0; j < d; ++j) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(itr.nextCoordinate());
            }
            sb.append(")");
            itr.resetToNextPoint();
        }
        return sb.toString();
    }

    protected class DefaultPointSetIterator
    implements PointSetIterator {
        protected int curPointIndex = 0;
        protected int curCoordIndex = 0;
        protected double EpsilonHalf = 1.0 / Num.TWOEXP[55];

        protected DefaultPointSetIterator() {
        }

        protected void outOfBounds() {
            if (this.getCurPointIndex() >= PointSet.this.numPoints) {
                throw new NoSuchElementException("Not enough points available");
            }
            throw new NoSuchElementException("Not enough coordinates available");
        }

        @Override
        public void setCurCoordIndex(int j) {
            this.curCoordIndex = j;
        }

        @Override
        public void resetCurCoordIndex() {
            this.setCurCoordIndex(0);
        }

        @Override
        public int getCurCoordIndex() {
            return this.curCoordIndex;
        }

        @Override
        public boolean hasNextCoordinate() {
            return this.getCurCoordIndex() < PointSet.this.getDimension();
        }

        @Override
        public double nextCoordinate() {
            if (this.getCurPointIndex() >= PointSet.this.numPoints || this.getCurCoordIndex() >= PointSet.this.dim) {
                this.outOfBounds();
            }
            return PointSet.this.getCoordinate(this.curPointIndex, this.curCoordIndex++);
        }

        @Override
        public void nextCoordinates(double[] p, int d) {
            if (this.getCurCoordIndex() + d > PointSet.this.getDimension()) {
                this.outOfBounds();
            }
            for (int j = 0; j < d; ++j) {
                p[j] = this.nextCoordinate();
            }
        }

        @Override
        public void setCurPointIndex(int i) {
            this.curPointIndex = i;
            this.resetCurCoordIndex();
        }

        @Override
        public void resetCurPointIndex() {
            this.setCurPointIndex(0);
        }

        @Override
        public int resetToNextPoint() {
            this.setCurPointIndex(this.curPointIndex + 1);
            return this.curPointIndex;
        }

        @Override
        public int getCurPointIndex() {
            return this.curPointIndex;
        }

        @Override
        public boolean hasNextPoint() {
            return this.getCurPointIndex() < PointSet.this.getNumPoints();
        }

        @Override
        public int nextPoint(double[] p, int fromDim, int d) {
            this.setCurCoordIndex(fromDim);
            this.nextCoordinates(p, d);
            return this.resetToNextPoint();
        }

        @Override
        public int nextPoint(double[] p, int d) {
            this.resetCurCoordIndex();
            this.nextCoordinates(p, d);
            return this.resetToNextPoint();
        }

        @Override
        public void resetStartStream() {
            this.resetCurPointIndex();
        }

        @Override
        public void resetStartSubstream() {
            this.resetCurCoordIndex();
        }

        @Override
        public void resetNextSubstream() {
            this.resetToNextPoint();
        }

        public void setAntithetic(boolean b) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double nextDouble() {
            return this.nextCoordinate();
        }

        @Override
        public void nextArrayOfDouble(double[] u, int start, int n) {
            if (n < 0) {
                throw new IllegalArgumentException("n must be positive.");
            }
            for (int i = start; i < start + n; ++i) {
                u[i] = this.nextDouble();
            }
        }

        @Override
        public int nextInt(int i, int j) {
            return i + (int)(this.nextDouble() * ((double)(j - i) + 1.0));
        }

        @Override
        public void nextArrayOfInt(int i, int j, int[] u, int start, int n) {
            if (n < 0) {
                throw new IllegalArgumentException("n must be positive.");
            }
            for (int k = start; k < start + n; ++k) {
                u[k] = this.nextInt(i, j);
            }
        }

        public String formatState() {
            return "Current point index: " + this.getCurPointIndex() + PrintfFormat.NEWLINE + "Current coordinate index: " + this.getCurCoordIndex();
        }
    }
}

