/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.hups;

import umontreal.ssj.hups.CachedPointSet;
import umontreal.ssj.hups.PointSetRandomization;
import umontreal.ssj.rng.RandomPermutation;
import umontreal.ssj.rng.RandomStream;

public class LatinHypercube
extends CachedPointSet {
    protected double delta;

    public LatinHypercube(int n, int dim) {
        this.dim = dim;
        this.delta = 1.0 / (double)n;
        this.numPoints = n;
        this.x = new double[this.numPoints][dim];
    }

    @Override
    public void randomize(RandomStream stream) {
        int[] permutation = new int[this.numPoints];
        for (int i = 0; i < this.numPoints; ++i) {
            permutation[i] = i;
            this.x[i][0] = ((double)i + stream.nextDouble()) * this.delta;
        }
        for (int j = 1; j < this.dim; ++j) {
            RandomPermutation.shuffle(permutation, stream);
            for (int i = 0; i < this.numPoints; ++i) {
                this.x[permutation[i]][j] = ((double)i + stream.nextDouble()) * this.delta;
            }
        }
    }

    @Override
    public void addRandomShift(int fromDim, int toDim, RandomStream stream) {
        this.randomize(stream);
    }

    @Override
    public void randomize(PointSetRandomization rand) {
        this.randomize(rand.getStream());
    }

    @Override
    public String toString() {
        return "LatinHypercube: LHS over the unit cube in " + this.dim + "dimensions.";
    }
}

