/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.hups;

import java.util.Arrays;
import umontreal.ssj.hups.PointSet;
import umontreal.ssj.hups.PointSetIterator;
import umontreal.ssj.hups.PointSetRandomization;
import umontreal.ssj.rng.RandomStream;
import umontreal.ssj.util.PrintfFormat;
import umontreal.ssj.util.sort.DoubleArrayComparator;
import umontreal.ssj.util.sort.MultiDimSort;

public class CachedPointSet
extends PointSet {
    protected PointSet P;
    protected double[][] x;
    int fromPoint = 0;
    int fromDim = 0;
    boolean randomizeParent = true;

    protected CachedPointSet() {
    }

    public CachedPointSet(PointSet P, int fromPoint, int toPoint, int fromDim, int toDim) {
        if (P.getNumPoints() < toPoint - fromPoint) {
            throw new IllegalArgumentException("Cannot cache more points than in point set P.");
        }
        if (P.getDimension() < toDim - fromDim) {
            throw new IllegalArgumentException("Attempt to cache points using more coordinates than the dimension.");
        }
        if (toPoint == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot cache infinite number of points");
        }
        if (toDim == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot cache infinite dimensional points");
        }
        this.fromPoint = fromPoint;
        this.numPoints = toPoint - fromPoint;
        this.fromDim = fromDim;
        this.dim = toDim - fromDim;
        this.P = P;
        this.x = new double[this.numPoints][this.dim];
        this.fillCache(fromDim, this.dim);
    }

    protected void fillCache(int fromDim, int dim) {
        PointSetIterator itr = this.P.iterator();
        if (this.fromPoint > 0) {
            itr.setCurPointIndex(this.fromPoint);
        }
        for (int i = 0; i < this.numPoints; ++i) {
            itr.nextPoint(this.x[i], fromDim, dim);
        }
    }

    public CachedPointSet(PointSet P, int n, int dim) {
        this(P, 0, n, 0, dim);
    }

    public CachedPointSet(PointSet P) {
        this(P, 0, P.getNumPoints(), 0, P.getDimension());
    }

    @Override
    public PointSetIterator iterator() {
        return new CachedPointSetIterator();
    }

    public void setRandomizeParent(boolean randomizeParent) {
        this.randomizeParent = randomizeParent;
    }

    @Override
    public void addRandomShift(int d1, int d2, RandomStream stream) {
        this.P.addRandomShift(d1, d2, stream);
        this.fillCache(this.fromDim, this.dim);
    }

    @Override
    public void randomize(PointSetRandomization rand) {
        if (this.randomizeParent) {
            this.P.randomize(rand);
            this.fillCache(this.fromDim, this.dim);
        } else {
            rand.randomize(this);
        }
    }

    public void sortByCoordinate(int j) {
        Arrays.sort(this.x, new DoubleArrayComparator(j));
    }

    public <T> void sort(MultiDimSort<T> sort) {
        sort.sort(this.x);
    }

    public void stripCoordinates(int d) {
        for (int i = 0; i < this.numPoints; ++i) {
            for (int j = 0; j < d; ++j) {
                this.x[i][j] = this.x[i][j + d];
            }
        }
        this.dim -= d;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("Cached point set" + PrintfFormat.NEWLINE);
        sb.append(super.toString());
        sb.append(PrintfFormat.NEWLINE + "Cached point set information {" + PrintfFormat.NEWLINE);
        sb.append(this.P.toString());
        sb.append(PrintfFormat.NEWLINE + "}");
        return sb.toString();
    }

    @Override
    public double getCoordinate(int i, int j) {
        return this.x[i][j];
    }

    public double[][] getArray() {
        return this.x;
    }

    public PointSet getParentPointSet() {
        return this.P;
    }

    protected class CachedPointSetIterator
    extends PointSet.DefaultPointSetIterator {
        protected CachedPointSetIterator() {
            super(CachedPointSet.this);
        }

        @Override
        public double nextCoordinate() {
            if (this.getCurPointIndex() >= CachedPointSet.this.numPoints || this.getCurCoordIndex() >= CachedPointSet.this.dim) {
                this.outOfBounds();
            }
            return CachedPointSet.this.x[this.curPointIndex][this.curCoordIndex++];
        }

        @Override
        public void nextCoordinates(double[] p, int d) {
            if (this.getCurCoordIndex() + d > CachedPointSet.this.getDimension()) {
                this.outOfBounds();
            }
            for (int j = 0; j < d; ++j) {
                p[j] = CachedPointSet.this.x[this.curPointIndex][this.curCoordIndex++];
            }
        }
    }
}

