package org.sharengo.wikitty.solr;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.CommonParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.LuceneQParserPlugin;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SolrQueryParser;

/**
 * Add allow leading wildcard
 * setAllowLeadingWildcard(true);
 * <br>Example: <code>{!wikitty q.op=AND df=text sort='price asc'}myfield:foo +bar -baz</code>
 * More information @see LuceneQParserPlugin
 */
public class WikittyQueryParser extends LuceneQParserPlugin {

    public static String NAME = "wikitty";

    @Override
    public void init(NamedList args) {
    }

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new SolrQParser(qstr, localParams, params, req);
    }
}

class SolrQParser extends QParser {

    static private Log log = LogFactory.getLog(SolrQParser.class);
    String sortStr;
    SolrQueryParser lparser;

    public SolrQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    @Override
    public Query parse() throws ParseException {

        String defaultField = getParam(CommonParams.DF);
        if(defaultField == null) {
            defaultField = "text";
        }

        lparser = new SolrQueryParser(this, defaultField);
        lparser.setAllowLeadingWildcard(true);
        
        String opParam = getParam(QueryParsing.OP);
        if (opParam != null) {
            lparser.setDefaultOperator("AND".equals(opParam) ? QueryParser.Operator.AND : QueryParser.Operator.OR);
        }

        String qstr = getString();
        log.debug("Query parse : " + qstr);
        return lparser.parse(qstr);
    }

    @Override
    public String[] getDefaultHighlightFields() {
        return new String[]{lparser.getField()};
    }
}
