/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.ui;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.ui.FieldExtension;
import org.nuiton.wikitty.ui.FormModel;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Datebox;
import org.zkoss.zul.Decimalbox;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.Textbox;

public class WikittyForm {
    protected FormModel _formModel = new FormModel();
    protected List<WikittyExtension> _holdExtensions = new ArrayList();
    protected Wikitty _wikitty = null;

    public void createModelFieldExtensions() {
        ArrayList<FieldExtension> fieldExtensions = new ArrayList<FieldExtension>();
        for (WikittyExtension wikittyExtension : this._holdExtensions) {
            Collection extensionNames = wikittyExtension.getFieldNames();
            for (String name : extensionNames) {
                FieldType fieldType = wikittyExtension.getFieldType(name);
                FieldExtension fieldExtension = new FieldExtension(fieldType, name, wikittyExtension);
                fieldExtensions.add(fieldExtension);
            }
        }
        this._formModel.setFieldExtensions(fieldExtensions);
    }

    List<Component> getComponentsByWikittyDateType(FieldExtension fieldExtension) {
        Date obj;
        ArrayList<Component> components = new ArrayList<Component>();
        FieldType fieldType = fieldExtension.getFieldType();
        String wikittyExtensionName = fieldExtension.getWikittyExtension().getName();
        if (this._wikitty != null && this._wikitty.hasExtension(wikittyExtensionName) && (obj = this._wikitty.getFieldAsDate(wikittyExtensionName, fieldExtension.getName())) != null) {
            if (fieldType.isCollection()) {
                List dates = this._wikitty.getFieldAsList(wikittyExtensionName, fieldExtension.getName(), Date.class);
                for (Date date : dates) {
                    components.add((Component)new Datebox(date));
                }
            } else {
                components.add((Component)new Datebox(obj));
            }
            return components;
        }
        components.add((Component)new Datebox());
        return components;
    }

    List<Component> getComponentsByWikittyNumericType(FieldExtension fieldExtension) {
        BigDecimal obj;
        ArrayList<Component> components = new ArrayList<Component>();
        FieldType fieldType = fieldExtension.getFieldType();
        String wikittyExtensionName = fieldExtension.getWikittyExtension().getName();
        if (this._wikitty != null && this._wikitty.hasExtension(wikittyExtensionName) && (obj = this._wikitty.getFieldAsBigDecimal(wikittyExtensionName, fieldExtension.getName())) != null) {
            if (fieldType.isCollection()) {
                List decimals = this._wikitty.getFieldAsList(wikittyExtensionName, fieldExtension.getName(), BigDecimal.class);
                for (BigDecimal decimal : decimals) {
                    components.add((Component)new Decimalbox(decimal));
                }
            } else {
                components.add((Component)new Decimalbox(obj));
            }
            return components;
        }
        components.add((Component)new Decimalbox());
        return components;
    }

    List<Component> getComponentsByWikittyStringType(FieldExtension fieldExtension) {
        String obj;
        ArrayList<Component> components = new ArrayList<Component>();
        FieldType fieldType = fieldExtension.getFieldType();
        String wikittyExtensionName = fieldExtension.getWikittyExtension().getName();
        if (this._wikitty != null && this._wikitty.hasExtension(wikittyExtensionName) && (obj = this._wikitty.getFieldAsString(wikittyExtensionName, fieldExtension.getName())) != null) {
            if (fieldType.isCollection()) {
                List strings = this._wikitty.getFieldAsList(wikittyExtensionName, fieldExtension.getName(), String.class);
                for (String str : strings) {
                    components.add((Component)new Textbox(str));
                }
            } else {
                components.add((Component)new Textbox(obj));
            }
            return components;
        }
        components.add((Component)new Textbox());
        return components;
    }

    List<Component> getComponentsByWikittyBooleanType(FieldExtension fieldExtension) {
        Boolean obj;
        ArrayList<Component> components = new ArrayList<Component>();
        FieldType fieldType = fieldExtension.getFieldType();
        String wikittyExtensionName = fieldExtension.getWikittyExtension().getName();
        if (this._wikitty != null && this._wikitty.hasExtension(wikittyExtensionName) && (obj = Boolean.valueOf(this._wikitty.getFieldAsBoolean(wikittyExtensionName, fieldExtension.getName()))) != null) {
            if (fieldType.isCollection()) {
                List bools = this._wikitty.getFieldAsList(wikittyExtensionName, fieldExtension.getName(), Boolean.class);
                for (Boolean bool : bools) {
                    Checkbox newCheckBox = new Checkbox();
                    newCheckBox.setChecked(bool.booleanValue());
                    components.add((Component)newCheckBox);
                }
            } else {
                Checkbox newCheckBox = new Checkbox();
                newCheckBox.setChecked(obj.booleanValue());
                components.add((Component)newCheckBox);
            }
            return components;
        }
        components.add((Component)new Checkbox());
        return components;
    }

    protected List<Date> getSetDateByCell(Listcell cell) {
        ArrayList<Date> dates = new ArrayList<Date>();
        List children = cell.getChildren();
        for (Datebox dateBox : children) {
            Date newDate = dateBox.getValue();
            dates.add(newDate);
        }
        return dates;
    }

    protected List<BigDecimal> getSetNumByCell(Listcell cell) {
        ArrayList<BigDecimal> nums = new ArrayList<BigDecimal>();
        List children = cell.getChildren();
        for (Decimalbox decimal : children) {
            BigDecimal newDecimal = decimal.getValue();
            nums.add(newDecimal);
        }
        return nums;
    }

    protected List<String> getSetStringByCell(Listcell cell) {
        ArrayList<String> strings = new ArrayList<String>();
        List children = cell.getChildren();
        for (Textbox textBox : children) {
            String newString = textBox.getValue();
            strings.add(newString);
        }
        return strings;
    }

    protected List<Boolean> getSetBoolByCell(Listcell cell) {
        ArrayList<Boolean> booleans = new ArrayList<Boolean>();
        List children = cell.getChildren();
        for (Checkbox checkBox : children) {
            Boolean newBoolean = checkBox.isChecked();
            booleans.add(newBoolean);
        }
        return booleans;
    }

    public Wikitty retriveWikittyInForm(Listbox formListBox, Wikitty newWikitty) {
        if (newWikitty == null) {
            newWikitty = this._wikitty;
        }
        newWikitty.addExtension(this._holdExtensions);
        List items = formListBox.getItems();
        for (Listitem item : items) {
            FieldExtension fieldExtension = (FieldExtension)item.getValue();
            String extensionName = fieldExtension.getWikittyExtension().getName();
            FieldType fieldType = fieldExtension.getFieldType();
            String fieldName = fieldExtension.getName();
            String id = extensionName + "." + fieldName;
            Listcell cell = (Listcell)item.getFellowIfAny(id);
            FieldType.TYPE type = fieldType.getType();
            List collection = null;
            if (type == FieldType.TYPE.DATE) {
                collection = this.getSetDateByCell(cell);
            } else if (type == FieldType.TYPE.NUMERIC) {
                collection = this.getSetNumByCell(cell);
            } else if (type == FieldType.TYPE.STRING) {
                collection = this.getSetStringByCell(cell);
            } else if (type == FieldType.TYPE.BOOLEAN) {
                collection = this.getSetBoolByCell(cell);
            }
            if (fieldType.isCollection()) {
                if (this._wikitty != null) {
                    newWikitty.clearField(extensionName, fieldName);
                }
                for (Object obj : collection) {
                    newWikitty.addToField(extensionName, fieldName, obj);
                }
                continue;
            }
            newWikitty.setField(extensionName, fieldName, collection.get(0));
        }
        return newWikitty;
    }

    public void deleteInput(Listbox formListBox) {
        FieldExtension fieldExtension;
        FieldType fieldType;
        Listitem item = formListBox.getSelectedItem();
        if (item != null && (fieldType = (fieldExtension = (FieldExtension)item.getValue()).getFieldType()).isCollection()) {
            List children;
            String extensionName = fieldExtension.getWikittyExtension().getName();
            String fieldName = fieldExtension.getName();
            String id = extensionName + "." + fieldName;
            Listcell cell = (Listcell)item.getFellowIfAny(id);
            if (cell != null && (children = cell.getChildren()).size() > 1) {
                children.remove(children.size() - 1);
            }
        }
    }

    public void addNewInput(Listbox formListBox) {
        FieldExtension fieldExtension;
        FieldType fieldType;
        Listitem item = formListBox.getSelectedItem();
        if (item != null && (fieldType = (fieldExtension = (FieldExtension)item.getValue()).getFieldType()).isCollection()) {
            String extensionName = fieldExtension.getWikittyExtension().getName();
            String fieldName = fieldExtension.getName();
            String id = extensionName + "." + fieldName;
            Listcell cell = (Listcell)item.getFellowIfAny(id);
            if (cell != null) {
                Component comp = cell.getFirstChild();
                cell.appendChild((Component)comp.clone());
            }
        }
    }

    public boolean isSelected() {
        return this._wikitty != null;
    }

    public void addExtension(WikittyExtension newExtension) {
        if (newExtension != null && !this._holdExtensions.contains(newExtension)) {
            boolean bool = false;
            String extensionName = newExtension.getName();
            for (WikittyExtension extension : this._holdExtensions) {
                if (!extensionName.equals(extension.getName())) continue;
                bool = true;
                break;
            }
            if (!bool) {
                this._holdExtensions.add(newExtension);
                this.createModelFieldExtensions();
            }
        }
    }

    public void removeExtension(WikittyExtension removeExtension) {
    }

    public ListitemRenderer getFieldExtensionRenderer() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void setHoldExtensions(List<WikittyExtension> holdExtensions) {
        this._wikitty = null;
        this._holdExtensions = holdExtensions;
        this.createModelFieldExtensions();
    }

    public void setHoldExtensions(WikittyExtension holdExtension) {
        this._wikitty = null;
        this._holdExtensions.clear();
        this._holdExtensions.add(holdExtension);
        this.createModelFieldExtensions();
    }

    public void setWikitty(Wikitty wikitty) {
        this._wikitty = wikitty;
        if (wikitty != null) {
            this._holdExtensions = new ArrayList(this._wikitty.getExtensions());
            this.createModelFieldExtensions();
        }
    }

    public List<WikittyExtension> getHoldExtensions() {
        return this._holdExtensions;
    }

    public FormModel getFormModel() {
        return this._formModel;
    }

    public Wikitty getWikitty() {
        return this._wikitty;
    }
}

