/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.perftest;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.perftest.PerfTestUtils;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;
import org.nuiton.wikitty.services.WikittyServiceEnhanced;

public class PerfTestSearch {
    private static Log log = LogFactory.getLog(PerfTestSearch.class);

    private static void searchGt(int researches, WikittyService ws, WikittyExtension ext, String searchIn, String searched, boolean withRestore) {
        for (int i = 0; i < researches; ++i) {
            Criteria criteria = Search.query().gt(ext.getName() + "." + searchIn, searched).criteria();
            PagedResult result = ws.findAllByCriteria(null, criteria);
            List found = result.getAll();
            for (String aFound : found) {
                if (!withRestore) continue;
                Wikitty wikittyFound = WikittyServiceEnhanced.restore((WikittyService)ws, null, (String)aFound);
                wikittyFound.getFieldAsString(ext.getName(), searchIn);
            }
        }
    }

    public static void oneThreadSearch(WikittyService ws, WikittyExtension ext, int loopsToAvg, int researches, int wikittiesCreated, String searchIn, String searched, boolean withRestore) {
        long time = System.currentTimeMillis();
        for (int i = 0; i < loopsToAvg; ++i) {
            PerfTestSearch.searchGt(researches, ws, ext, searchIn, searched, withRestore);
        }
        time = System.currentTimeMillis() - time;
        if (withRestore) {
            PerfTestUtils.out("With WikittyServiceEnhanced.restore : ");
        } else {
            PerfTestUtils.out("Without WikittyServiceEnhanced.restore : ");
        }
        PerfTestUtils.out("1 thread took (average on " + loopsToAvg + " loops) " + time / (long)loopsToAvg + " ms to do " + researches + " researches on field " + searchIn + " in " + wikittiesCreated + " wikitties\n");
    }

    public static void nThreadsSearch(WikittyService ws, WikittyExtension ext, int loopsToAvg, int researches, int wikittiesCreated, int threadsNb, String searchIn, String searched, boolean withRestore) {
        ArrayList<PerfTestSearchThread> threads = new ArrayList<PerfTestSearchThread>();
        long time = System.currentTimeMillis();
        int threadMod = researches % threadsNb != 0 ? 1 : 0;
        for (int j = 0; j < loopsToAvg; ++j) {
            int i;
            for (i = 0; i < threadsNb; ++i) {
                threads.add(new PerfTestSearchThread(researches / threadsNb, ws, ext, withRestore, searchIn, searched));
            }
            if (threadMod == 1) {
                threads.add(new PerfTestSearchThread(researches % threadsNb, ws, ext, withRestore, searchIn, searched));
            }
            for (i = 0; i < threadsNb + threadMod; ++i) {
                ((PerfTestSearchThread)threads.get(i)).start();
            }
            for (i = 0; i < threadsNb + threadMod; ++i) {
                try {
                    ((PerfTestSearchThread)threads.get(i)).join();
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            threads.clear();
        }
        time = System.currentTimeMillis() - time;
        if (withRestore) {
            PerfTestUtils.out("With WikittyServiceEnhanced.restore : ");
        } else {
            PerfTestUtils.out("Without WikittyServiceEnhanced.restore : ");
        }
        PerfTestUtils.out(threadsNb + (threadMod == 1 ? "(+1)" : "") + " threads took (average on " + loopsToAvg + " loops) " + time / (long)loopsToAvg + " ms to do " + researches / threadsNb + " researches each " + (threadMod == 1 ? "(+" + researches % threadsNb + " researches) " : "") + "on field " + searchIn + " in " + wikittiesCreated + " wikitties\n");
    }

    public static void search(WikittyService ws, WikittyExtension ext, int loopsToAvg, int researches, int wikittiesCreated, int threadsNb, String searchIn, String searched, boolean withRestore) {
        PerfTestSearch.oneThreadSearch(ws, ext, loopsToAvg, researches, wikittiesCreated, searchIn, searched, withRestore);
        PerfTestSearch.nThreadsSearch(ws, ext, loopsToAvg, researches, wikittiesCreated, threadsNb, searchIn, searched, withRestore);
    }

    private static class PerfTestSearchThread
    extends Thread {
        private int researches;
        private WikittyService ws;
        private WikittyExtension ext;
        private boolean withRestore;
        private String searchIn;
        private String searched;

        PerfTestSearchThread(int researches, WikittyService ws, WikittyExtension ext, boolean withRestore, String searchIn, String searched) {
            this.researches = researches;
            this.ws = ws;
            this.ext = ext;
            this.withRestore = withRestore;
            this.searchIn = searchIn;
            this.searched = searched;
        }

        @Override
        public void run() {
            PerfTestSearch.searchGt(this.researches, this.ws, this.ext, this.searchIn, this.searched, this.withRestore);
        }
    }
}

