/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.generator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.AbstractMetaTransformer;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.wikitty.generator.WikittyAbstractGenerator;
import org.nuiton.wikitty.generator.WikittyContractGenerator;
import org.nuiton.wikitty.generator.WikittyHelperGenerator;
import org.nuiton.wikitty.generator.WikittyImplementationGenerator;
import org.nuiton.wikitty.generator.WikittyPurifierTransformer;
import org.nuiton.wikitty.generator.WikittyTagValue;

public class WikittyMetaTransformer
extends AbstractMetaTransformer<ObjectModel>
implements WikittyTagValue {
    private static final Log log = LogFactory.getLog(WikittyMetaTransformer.class);

    public WikittyMetaTransformer() {
        this.setTransformerTypes(new Class[]{WikittyPurifierTransformer.class});
        this.setTemplateTypes(new Class[]{WikittyContractGenerator.class, WikittyAbstractGenerator.class, WikittyImplementationGenerator.class, WikittyHelperGenerator.class});
    }

    protected boolean validateModel(ObjectModel model) {
        if (model.getClasses().isEmpty() && log.isWarnEnabled()) {
            log.warn((Object)"model does not contain any class to generate.");
        }
        for (ObjectModelClass clazz : model.getClasses()) {
            if (clazz.getStereotypes().contains("BusinessEntity")) {
                log.warn((Object)(clazz.getQualifiedName() + " uses deprecated \"" + "BusinessEntity" + "\" stereotype. use \"" + "entity" + "\" instead"));
            }
            if (clazz.hasTagValue("version")) continue;
            log.warn((Object)(clazz.getQualifiedName() + " misses a \"" + "version" + "\" tagValue"));
        }
        return true;
    }
}

