package org.nuiton.wikitty.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public class ProductHelper {

    /**
     * utility class all provided methods are accessible the static way
     */
    private ProductHelper() {// empty
}

    public static String getName(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Product.EXT_PRODUCT, Product.FIELD_PRODUCT_NAME);
        return value;
}

    public static String setName(Wikitty wikitty, String name) {
        String oldValue = getName(wikitty);
        wikitty.setField(Product.EXT_PRODUCT, Product.FIELD_PRODUCT_NAME, name);
        return oldValue;
}

    public static int getPrice(Wikitty wikitty) {
        int value = wikitty.getFieldAsInt(Product.EXT_PRODUCT, Product.FIELD_PRODUCT_PRICE);
        return value;
}

    public static int setPrice(Wikitty wikitty, int price) {
        int oldValue = getPrice(wikitty);
        wikitty.setField(Product.EXT_PRODUCT, Product.FIELD_PRODUCT_PRICE, price);
        return oldValue;
}

    public static Set<String> getColors(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(Product.EXT_PRODUCT, Product.FIELD_PRODUCT_COLORS, String.class);
        return result;
}

    public static void setColors(Wikitty wikitty, Set<String> colors) {
        wikitty.setField(Product.EXT_PRODUCT, Product.FIELD_PRODUCT_COLORS, colors);
}

    public static void addAllColors(Wikitty wikitty, Collection<String> colors) {
        if(colors != null){
            for (String v:colors){
                addColors(wikitty, v);
            }
        }
}

    public static void addColors(Wikitty wikitty, String... element) {
        for (String v : element) {
            wikitty.addToField(Product.EXT_PRODUCT, Product.FIELD_PRODUCT_COLORS, v);
        }
}

    public static void removeColors(Wikitty wikitty, String... element) {
        for (String v : element) {
            wikitty.removeFromField(Product.EXT_PRODUCT, Product.FIELD_PRODUCT_COLORS, v);
        }
}

    public static void clearColors(Wikitty wikitty) {
        wikitty.clearField(Product.EXT_PRODUCT, Product.FIELD_PRODUCT_COLORS);
}

    public static Date getDate(Wikitty wikitty) {
        Date value = wikitty.getFieldAsDate(Product.EXT_PRODUCT, Product.FIELD_PRODUCT_DATE);
        return value;
}

    public static Date setDate(Wikitty wikitty, Date date) {
        Date oldValue = getDate(wikitty);
        wikitty.setField(Product.EXT_PRODUCT, Product.FIELD_PRODUCT_DATE, date);
        return oldValue;
}

    public static String getCategory(Wikitty wikitty) {
        String value = wikitty.getFieldAsWikitty(Product.EXT_PRODUCT, Product.FIELD_PRODUCT_CATEGORY);
        return value;
}

    public static String setCategory(Wikitty wikitty, String category) {
        String oldValue = getCategory(wikitty);
        wikitty.setField(Product.EXT_PRODUCT, Product.FIELD_PRODUCT_CATEGORY, category);
        return oldValue;
}

    public static Category getCategory(Wikitty wikitty, boolean exceptionIfNotLoaded) {
        Category value = WikittyUtil.newInstance(Category.class, wikitty.getFieldAsWikitty(Product.EXT_PRODUCT, Product.FIELD_PRODUCT_CATEGORY, exceptionIfNotLoaded));
        return value;
}

    public static Category setCategory(Wikitty wikitty, Category category) {
        Category oldValue = getCategory(wikitty, false);
        wikitty.setField(Product.EXT_PRODUCT, Product.FIELD_PRODUCT_CATEGORY, category);
        return oldValue;
}

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(Product.EXT_PRODUCT, Product.FIELD_PRODUCT_NAME);
            Object f2 = w2.getFieldAsObject(Product.EXT_PRODUCT, Product.FIELD_PRODUCT_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Product.EXT_PRODUCT, Product.FIELD_PRODUCT_PRICE);
            Object f2 = w2.getFieldAsObject(Product.EXT_PRODUCT, Product.FIELD_PRODUCT_PRICE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Product.EXT_PRODUCT, Product.FIELD_PRODUCT_COLORS);
            Object f2 = w2.getFieldAsObject(Product.EXT_PRODUCT, Product.FIELD_PRODUCT_COLORS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Product.EXT_PRODUCT, Product.FIELD_PRODUCT_DATE);
            Object f2 = w2.getFieldAsObject(Product.EXT_PRODUCT, Product.FIELD_PRODUCT_DATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Product.EXT_PRODUCT, Product.FIELD_PRODUCT_CATEGORY);
            Object f2 = w2.getFieldAsObject(Product.EXT_PRODUCT, Product.FIELD_PRODUCT_CATEGORY);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return 
     */
    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * check if wikitty has current extension
     * @param wikitty 
     * @return 
     */
    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(Product.EXT_PRODUCT);
}

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */
    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : ProductAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @param wikitty 
     * @return 
     */
    public static String toString(Wikitty wikitty) {

        return wikitty.toString(Product.EXT_PRODUCT);
}

} //ProductHelper
