package org.nuiton.wikitty.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public abstract class PegasusAbstract extends BusinessEntityImpl implements Pegasus {

    public static final List<WikittyExtension> extensions;

    public static final WikittyExtension extensionPegasus;

    @Override
    public String getSex() {
String value = PegasusHelper.getSex(getWikitty());
return value;
}

    @Override
    public void setSex(String sex) {
String oldValue = getSex();
PegasusHelper.setSex(getWikitty(), sex);
getPropertyChangeSupport().firePropertyChange(Pegasus.FIELD_PEGASUS_SEX, oldValue, getSex());
}

    @Override
    public String getRealm() {
String value = PegasusHelper.getRealm(getWikitty());
return value;
}

    @Override
    public void setRealm(String realm) {
String oldValue = getRealm();
PegasusHelper.setRealm(getWikitty(), realm);
getPropertyChangeSupport().firePropertyChange(Pegasus.FIELD_PEGASUS_REALM, oldValue, getRealm());
}

    @Override
    public int getLegs() {
int value = HorseHelper.getLegs(getWikitty());
return value;
}

    @Override
    public void setLegs(int legs) {
int oldValue = getLegs();
HorseHelper.setLegs(getWikitty(), legs);
getPropertyChangeSupport().firePropertyChange(Horse.FIELD_HORSE_LEGS, oldValue, getLegs());
}

    @Override
    public String getColor() {
String value = HorseHelper.getColor(getWikitty());
return value;
}

    @Override
    public void setColor(String color) {
String oldValue = getColor();
HorseHelper.setColor(getWikitty(), color);
getPropertyChangeSupport().firePropertyChange(Horse.FIELD_HORSE_COLOR, oldValue, getColor());
}

    @Override
    public int getFly() {
int value = BirdHelper.getFly(getWikitty());
return value;
}

    @Override
    public void setFly(int fly) {
int oldValue = getFly();
BirdHelper.setFly(getWikitty(), fly);
getPropertyChangeSupport().firePropertyChange(Bird.FIELD_BIRD_FLY, oldValue, getFly());
}

    @Override
    public String getColorFromBird() {
String value = BirdHelper.getColor(getWikitty());
return value;
}

    @Override
    public void setColorFromBird(String color) {
String oldValue = getColorFromBird();
BirdHelper.setColor(getWikitty(), color);
getPropertyChangeSupport().firePropertyChange(Bird.FIELD_BIRD_COLOR, oldValue, getColorFromBird());
}

    public PegasusAbstract() {
        super();
}

    public PegasusAbstract(Wikitty wikitty) {
        super(wikitty);
}

    public PegasusAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

    static {
    
        extensionPegasus = new WikittyExtension(EXT_PEGASUS,
                "1.0", // version
                WikittyUtil.tagValuesToMap(" alternativeName.Bird.color=\"colorFromBird\""), // tag/values
                Horse.EXT_HORSE + "," + Bird.EXT_BIRD,
                WikittyUtil.buildFieldMapExtension( // building field map
                                                                 "String sex unique=\"true\"", 
                                             "Wikitty realm unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(HorseAbstract.extensions); 
        // current after requires ones

        exts.addAll(BirdAbstract.extensions); 
        // current after requires ones

        exts.add(extensionPegasus);
        extensions = Collections.unmodifiableList(exts);

    }

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @return 
     */
    @Override
    public String toString() {
        return PegasusHelper.toString(getWikitty());
}

} //PegasusAbstract
