package org.nuiton.topia.taas.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.generator.EntityTransformer", date = "Sun Mar 22 16:44:41 UTC 2015")
public abstract class TaasPrincipalAbstract extends TopiaEntityAbstract implements TaasPrincipal {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : authorizations
     */
    protected Collection<TaasAuthorization> authorizations;

    private static final long serialVersionUID = 3761973761041260899L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(EntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_AUTHORIZATIONS, Collection.class, TaasAuthorization.class, authorizations);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
    }

    @Override
    public String getName() {
        fireOnPreRead(PROPERTY_NAME, name);

        String result = this.name;

        fireOnPostRead(PROPERTY_NAME, name);

        return result;
    }

    @Override
    public void addAuthorizations(TaasAuthorization authorizations) {
        fireOnPreWrite(PROPERTY_AUTHORIZATIONS, null, authorizations);
        if (this.authorizations == null) {
            this.authorizations = new ArrayList<TaasAuthorization>();
        }

        this.authorizations.add(authorizations);
        fireOnPostWrite(PROPERTY_AUTHORIZATIONS, this.authorizations.size(), null, authorizations);
    }

    @Override
    public void addAllAuthorizations(Collection<TaasAuthorization> authorizations) {
        if (authorizations == null) {
            return;
        }
        for (TaasAuthorization item : authorizations) {
            addAuthorizations(item);
        }
    }

    @Override
    public void setAuthorizations(Collection<TaasAuthorization> authorizations) {
        // Copy elements to keep data for fire with new reference
        Collection<TaasAuthorization> oldValue = this.authorizations != null ? new ArrayList<TaasAuthorization>(this.authorizations) : null;
        fireOnPreWrite(PROPERTY_AUTHORIZATIONS, oldValue, authorizations);
        this.authorizations = authorizations;
        fireOnPostWrite(PROPERTY_AUTHORIZATIONS, oldValue, authorizations);
    }

    @Override
    public void removeAuthorizations(TaasAuthorization authorizations) {
        fireOnPreWrite(PROPERTY_AUTHORIZATIONS, authorizations, null);
        if (this.authorizations == null || !this.authorizations.remove(authorizations)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_AUTHORIZATIONS, this.authorizations.size() + 1, authorizations, null);
    }

    @Override
    public void clearAuthorizations() {
        if (this.authorizations == null) {
            return;
        }
        Collection<TaasAuthorization> oldValue = new ArrayList<TaasAuthorization>(this.authorizations);
        fireOnPreWrite(PROPERTY_AUTHORIZATIONS, oldValue, this.authorizations);
        this.authorizations.clear();
        fireOnPostWrite(PROPERTY_AUTHORIZATIONS, oldValue, this.authorizations);
    }

    @Override
    public Collection<TaasAuthorization> getAuthorizations() {
        return authorizations;
    }

    @Override
    public TaasAuthorization getAuthorizationsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(authorizations, topiaId);
    }

    @Override
    public int sizeAuthorizations() {
        if (authorizations == null) {
            return 0;
        }
        return authorizations.size();
    }

    @Override
    public boolean isAuthorizationsEmpty() {
        int size = sizeAuthorizations();
        return size == 0;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_NAME, this.name).
            append(PROPERTY_AUTHORIZATIONS, this.authorizations).
         toString();
        return result;
    }

} //TaasPrincipalAbstract
